/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.tileentity.totem;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.api.TotemicRegistries;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.tileentity.totem.StateTotemEffect;
import pokefenn.totemic.tileentity.totem.TileTotemBase;
import pokefenn.totemic.tileentity.totem.TotemState;

public final class StateCeremonyEffect
extends TotemState
implements CeremonyEffectContext {
    static final int ID = 3;
    private Ceremony ceremony;
    private int time = 0;

    StateCeremonyEffect(TileTotemBase tile) {
        super(tile);
    }

    StateCeremonyEffect(TileTotemBase tile, Ceremony ceremony) {
        this(tile);
        this.ceremony = ceremony;
    }

    public void func_73660_a() {
        this.ceremony.effect(this.tile.func_145831_w(), this.tile.func_174877_v(), this);
        if (!this.tile.func_145831_w().field_72995_K) {
            if (this.time >= this.ceremony.getEffectTime()) {
                this.ceremony.onEffectEnd(this.tile.func_145831_w(), this.tile.func_174877_v(), this);
                this.tile.setState(new StateTotemEffect(this.tile));
            }
        } else {
            if (this.ceremony.getEffectTime() == 0) {
                this.tile.setState(new StateTotemEffect(this.tile));
            }
            this.tile.setCeremonyOverlay();
        }
        ++this.time;
    }

    @Override
    public boolean acceptMusic(MusicInstrument instr, int amount, double x, double y, double z, @Nullable Entity entity) {
        this.spawnParticles(EnumParticleTypes.NOTE, 6);
        return true;
    }

    @Override
    int getID() {
        return 3;
    }

    @Override
    void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("ceremony", this.ceremony.getRegistryName().toString());
        tag.func_74768_a("time", this.time);
    }

    @Override
    void readFromNBT(NBTTagCompound tag) {
        this.ceremony = (Ceremony)TotemicRegistries.ceremonies().getValue(new ResourceLocation(tag.func_74779_i("ceremony")));
        if (this.ceremony == null) {
            Totemic.logger.warn("Unknown ceremony: {}", (Object)tag.func_74779_i("ceremony"));
            this.tile.setState(new StateTotemEffect(this.tile));
        }
        this.time = tag.func_74762_e("time");
    }

    public Ceremony getCeremony() {
        return this.ceremony;
    }

    @Override
    public int getTime() {
        return this.time;
    }
}

