/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.item.equipment.music;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.item.equipment.EquipmentMaterials;
import pokefenn.totemic.util.ItemUtil;

public class ItemJingleDress
extends ItemArmor
implements ISpecialArmor {
    public static final String TIME_KEY = "time";

    public ItemJingleDress() {
        super(EquipmentMaterials.JINGLE_DRESS, 0, EntityEquipmentSlot.LEGS);
        this.setRegistryName("jingle_dress");
        this.func_77655_b("totemic:jingle_dress");
        this.func_77637_a(Totemic.tabsTotem);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(1, 1.0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".tooltip"), (Object[])new Object[0]));
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        stack.func_77972_a(entity.field_70170_p.field_73012_v.nextInt(4), entity);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.field_72995_K && !player.func_175149_v() && world.func_82737_E() % 20L == 0L) {
            int time;
            NBTTagCompound tag = ItemUtil.getOrCreateTag(itemStack);
            int prevTime = time = tag.func_74771_c(TIME_KEY);
            double vx = player.field_70165_t - player.field_71094_bP;
            double vy = player.field_70163_u - player.field_71095_bQ;
            double vz = player.field_70161_v - player.field_71085_bR;
            double vel = Math.sqrt(vx * vx + vy * vy + vz * vz);
            if (player.func_70644_a(MobEffects.field_76424_c)) {
                vel *= 1.2;
            }
            int limit = 10;
            if ((time += MathHelper.func_76125_a((int)((int)(vel * 10.0)), (int)0, (int)8)) >= 10) {
                this.playMusic(world, player, itemStack);
                time %= 10;
            }
            if (time != prevTime) {
                tag.func_74774_a(TIME_KEY, (byte)time);
            }
        }
    }

    private void playMusic(World world, EntityPlayer player, ItemStack itemStack) {
        Totemic.api.music().playMusic((Entity)player, ModContent.jingleDress);
        this.particlesAllAround((WorldServer)world, player.field_70165_t, player.field_70163_u, player.field_70161_v);
    }

    private void particlesAllAround(WorldServer world, double x, double y, double z) {
        world.func_175739_a(EnumParticleTypes.NOTE, x, y + 0.4, z, 3, 0.5, 0.2, 0.5, 0.0, new int[0]);
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        return this.func_82812_d().func_78044_b(EntityEquipmentSlot.values()[slot]);
    }
}

