/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.music;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.init.ModSounds;
import pokefenn.totemic.tileentity.music.TileWindChime;
import pokefenn.totemic.util.EntityUtil;
import pokefenn.totemic.util.TotemUtil;

public class BlockWindChime
extends Block
implements ITileEntityProvider {
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, 1.0, (double)0.8f);

    public BlockWindChime() {
        super(Material.field_151573_f);
        this.setRegistryName("wind_chime");
        this.func_149663_c("totemic:wind_chime");
        this.func_149711_c(1.5f);
        this.func_149647_a(Totemic.tabsTotem);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)(this.func_149739_a() + ".tooltip"), (Object[])new Object[0]));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor, BlockPos fromPos) {
        if (!this.func_176196_c(world, pos)) {
            world.func_175698_g(pos);
            BlockWindChime.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Block)this));
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        world.func_175713_t(pos);
        for (TileWindChime chime : EntityUtil.getTileEntitiesInRange(TileWindChime.class, world, pos, 8, 8)) {
            chime.tryUncongest();
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState upState = world.func_180495_p(pos.func_177984_a());
        return world.func_175623_d(pos.func_177977_b()) && (world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN) || upState.func_177230_c().isLeaves(upState, (IBlockAccess)world, pos.func_177984_a()));
    }

    private boolean isCongested(World world, BlockPos pos) {
        return ((TileWindChime)world.func_175625_s(pos)).isCongested();
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70093_af() && !this.isCongested(world, pos)) {
            this.playSelector(world, pos, player);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            if (this.isCongested(world, pos)) {
                return false;
            }
            if (!world.field_72995_K) {
                this.playSelector(world, pos, player);
            }
            return true;
        }
        return false;
    }

    private void playSelector(World world, BlockPos pos, EntityPlayer player) {
        TotemUtil.playSound(world, pos, ModSounds.windChime, SoundCategory.PLAYERS, 1.0f, 1.0f);
        Totemic.api.music().playSelector(world, pos, (Entity)player, ModContent.windChime);
        ((WorldServer)world).func_175739_a(EnumParticleTypes.NOTE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.5, (double)pos.func_177952_p() + 0.5, 6, 0.0, 0.0, 0.0, 0.0, new int[0]);
        ((WorldServer)world).func_175739_a(EnumParticleTypes.FIREWORKS_SPARK, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.5, (double)pos.func_177952_p() + 0.5, 6, 0.0, 0.0, 0.0, 0.0, new int[0]);
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        if (!world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileWindChime) {
            ((TileWindChime)tile).setPlaying(param);
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileWindChime) {
            ((TileWindChime)tile).setNotPlaying();
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileWindChime();
    }
}

