/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api.totem;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.TotemicEntityUtil;
import pokefenn.totemic.api.totem.TotemBase;
import pokefenn.totemic.api.totem.TotemEffect;

public class TotemEffectPotion
extends TotemEffect {
    public static final int DEFAULT_INTERVAL = 80;
    protected final Potion potion;
    protected final int baseRange;
    protected final int baseAmplifier;

    public TotemEffectPotion(String name, Potion potion) {
        this(name, true, 6, potion, 80, 0);
    }

    public TotemEffectPotion(String name, boolean portable, int baseRange, Potion potion, int interval, int baseAmplifier) {
        super(name, portable, interval);
        this.potion = Objects.requireNonNull(potion);
        this.baseRange = baseRange;
        this.baseAmplifier = baseAmplifier;
    }

    protected int getHorizontalRange(World world, BlockPos pos, TotemBase totem, int repetition) {
        return TotemicAPI.get().totemEffect().getDefaultRange(this, this.baseRange, totem, repetition);
    }

    protected int getVerticalRange(World world, BlockPos pos, TotemBase totem, int repetition) {
        return this.getHorizontalRange(world, pos, totem, repetition);
    }

    protected int getAmplifier(World world, BlockPos pos, TotemBase totem, int repetition) {
        return this.baseAmplifier + (repetition - 1) / 2 + (totem.getTotemEffectMusic() > 96 ? 1 : 0);
    }

    protected int getAmplifierForMedicineBag(World world, EntityPlayer entity, ItemStack medicineBag, int charge) {
        return this.baseAmplifier + EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)medicineBag) / 2;
    }

    protected int getLingeringTime() {
        return 20;
    }

    protected void applyTo(boolean isMedicineBag, EntityPlayer player, int time, int amplifier) {
        player.func_70690_d(new PotionEffect(this.potion, time, amplifier, true, false));
    }

    @Override
    public void effect(World world, BlockPos pos, TotemBase totem, int repetition) {
        if (world.field_72995_K) {
            return;
        }
        int horizontal = this.getHorizontalRange(world, pos, totem, repetition);
        int vertical = this.getVerticalRange(world, pos, totem, repetition);
        int time = this.interval + this.getLingeringTime();
        int amplifier = this.getAmplifier(world, pos, totem, repetition);
        TotemicEntityUtil.getPlayersInRange(world, pos, horizontal, vertical).forEach(player -> this.applyTo(false, (EntityPlayer)player, time, amplifier));
    }

    @Override
    public void medicineBagEffect(World world, EntityPlayer player, ItemStack medicineBag, int charge) {
        if (world.field_72995_K) {
            return;
        }
        int time = this.interval + this.getLingeringTime();
        int amplifier = this.getAmplifierForMedicineBag(world, player, medicineBag, charge);
        this.applyTo(true, player, time, amplifier);
    }

    @Deprecated
    public static List<EntityPlayer> getPlayersInRange(World world, BlockPos pos, int horizontal, int vertical) {
        return TotemicEntityUtil.getPlayersInRange(world, pos, horizontal, vertical).collect(Collectors.toList());
    }
}

