/*
 * Decompiled with CFR 0.152.
 */
package uk.bobbytables.zenloot.crafttweaker.zenscript;

import crafttweaker.annotations.ZenRegister;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.RandomValueRange;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import uk.bobbytables.zenloot.crafttweaker.zenscript.MCLootPool;
import uk.bobbytables.zenloot.crafttweaker.zenscript.MCLootPoolExisting;
import uk.bobbytables.zenloot.crafttweaker.zenscript.MCLootPoolNew;
import uk.bobbytables.zenloot.util.tablematchers.PatternTableMatcher;
import uk.bobbytables.zenloot.util.tablematchers.SimpleTableMatcher;
import uk.bobbytables.zenloot.util.tablematchers.TableMatcher;

@ZenRegister
@ZenClass(value="mods.zenloot.LootTable")
public class MCLootTable {
    public static final List<MCLootTable> MODIFIED_TABLES = new ArrayList<MCLootTable>();
    public static final List<MCLootTable> MODIFIED_EARLY = new ArrayList<MCLootTable>();
    private final TableMatcher matcher;
    private final List<MCLootPool> lootPools = new ArrayList<MCLootPool>();

    public MCLootTable(ResourceLocation id) {
        this.matcher = new SimpleTableMatcher(id);
    }

    public MCLootTable(String pattern) {
        this.matcher = new PatternTableMatcher(pattern);
    }

    public boolean matches(ResourceLocation tableLoc) {
        return this.matcher.matches(tableLoc);
    }

    public List<MCLootPool> getLootPools() {
        return this.lootPools;
    }

    @ZenMethod
    public static MCLootTable edit(String id) {
        MCLootTable lootTable = new MCLootTable(new ResourceLocation(id));
        MODIFIED_TABLES.add(lootTable);
        return lootTable;
    }

    @ZenMethod
    public static MCLootTable editEarly(String id) {
        MCLootTable lootTable = new MCLootTable(new ResourceLocation(id));
        MODIFIED_EARLY.add(lootTable);
        return lootTable;
    }

    @ZenMethod
    public static MCLootTable editAllMatching(String pattern) {
        MCLootTable lootTable = new MCLootTable(pattern);
        MODIFIED_TABLES.add(lootTable);
        return lootTable;
    }

    @ZenMethod
    public MCLootPool getExistingPool(String name) {
        Optional<MCLootPool> lootPool = this.lootPools.stream().filter(pool -> pool.getName().equals(name)).findFirst();
        if (lootPool.isPresent()) {
            return lootPool.get();
        }
        MCLootPoolExisting lootPool1 = new MCLootPoolExisting(name);
        this.lootPools.add(lootPool1);
        return lootPool1;
    }

    @ZenMethod
    public MCLootPool addPool(String name, int minRolls, int maxRolls, int minBonusRolls, int maxBonusRolls) {
        Optional<MCLootPool> lootPool = this.lootPools.stream().filter(pool -> pool.getName().equals(name)).findFirst();
        if (lootPool.isPresent()) {
            return lootPool.get();
        }
        MCLootPoolNew lootPool1 = new MCLootPoolNew(name, new RandomValueRange((float)minRolls, (float)maxRolls), new RandomValueRange((float)minBonusRolls, (float)maxBonusRolls));
        this.lootPools.add(lootPool1);
        return lootPool1;
    }
}

