/*
 * Decompiled with CFR 0.152.
 */
package uk.bobbytables.zenloot.crafttweaker.zenscript;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.itemstages.ItemStages;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.EnchantRandomly;
import net.minecraft.world.storage.loot.functions.EnchantWithLevels;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import org.apache.logging.log4j.LogManager;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import uk.bobbytables.zenloot.crafttweaker.zenscript.MCLootCondition;
import uk.bobbytables.zenloot.crafttweaker.zenscript.MCLootEntry;
import uk.bobbytables.zenloot.crafttweaker.zenscript.MCLootFunction;
import uk.bobbytables.zenloot.loot.conditions.Staged;

@ZenRegister
@ZenClass(value="mods.zenloot.LootEntryItem")
public class MCLootEntryItem
extends MCLootEntry {
    private final Item item;
    private final ItemStack itemStack;
    private final List<LootFunction> lootFunctions = new ArrayList<LootFunction>();
    private boolean autoStage = false;

    MCLootEntryItem(ItemStack itemStack, String name) {
        super(name);
        if (itemStack.func_190916_E() > 1) {
            this.lootFunctions.add((LootFunction)new SetCount(new LootCondition[0], new RandomValueRange((float)itemStack.func_190916_E())));
        }
        if (itemStack.func_77942_o()) {
            this.lootFunctions.add((LootFunction)new SetNBT(new LootCondition[0], itemStack.func_77978_p()));
        }
        if (itemStack.func_77960_j() != 0) {
            this.lootFunctions.add((LootFunction)new SetMetadata(new LootCondition[0], new RandomValueRange((float)itemStack.func_77960_j())));
        }
        this.item = itemStack.func_77973_b();
        this.itemStack = itemStack;
    }

    @ZenMethod
    public static MCLootEntryItem fromItemStack(IItemStack iItemStack, @Optional String name) {
        return new MCLootEntryItem(CraftTweakerMC.getItemStack((IItemStack)iItemStack), name);
    }

    @Override
    public LootEntry build() {
        if (this.autoStage) {
            String stage = ItemStages.getStage((ItemStack)this.itemStack);
            if (stage != null) {
                LogManager.getLogger().info("{} adding to stage: {}", (Object)this.itemStack.func_77973_b().getRegistryName(), (Object)stage);
                this.lootConditions.add(new Staged(stage));
                this.autoStage = false;
            } else if (Loader.instance().getLoaderState() == LoaderState.SERVER_ABOUT_TO_START || Loader.instance().getLoaderState() == LoaderState.SERVER_STARTING || Loader.instance().getLoaderState() == LoaderState.SERVER_STARTED) {
                CraftTweakerAPI.logError((String)String.format("Tried to autostage an item which is not staged: %s", this.itemStack.func_77973_b().getRegistryName()));
            } else {
                CraftTweakerAPI.logWarning((String)String.format("Loot tables are being loaded before staging is finalised, skipping staging %s until later", this.itemStack.func_77973_b().getRegistryName()));
            }
        }
        return new LootEntryItem(this.item, this.weight, this.quality, this.lootFunctions.toArray(new LootFunction[0]), this.lootConditions.toArray(new LootCondition[0]), this.name == null ? this.item.getRegistryName().toString() : this.name);
    }

    @ZenMethod
    public MCLootEntryItem setDamage(float min, float max) {
        if (this.lootFunctions.stream().noneMatch(lootFunction -> lootFunction.getClass().equals(SetDamage.class))) {
            if (min < max && (double)max <= 1.0 && (double)min >= 0.0) {
                this.lootFunctions.add((LootFunction)new SetDamage(new LootCondition[0], new RandomValueRange(min, max)));
            } else {
                CraftTweakerAPI.logError((String)String.format("Tried to set an invalid damage for %s - must be 0.0 - 1.0", this.item.getRegistryName()));
            }
        } else {
            CraftTweakerAPI.logError((String)String.format("Tried to setDamage twice for %s", this.item.getRegistryName()));
        }
        return this;
    }

    @ZenMethod
    public MCLootEntryItem setCount(int min, int max) {
        if (this.lootFunctions.stream().noneMatch(lootFunction -> lootFunction.getClass().equals(SetCount.class))) {
            this.lootFunctions.add((LootFunction)new SetCount(new LootCondition[0], new RandomValueRange((float)min, (float)max)));
        } else {
            CraftTweakerAPI.logError((String)String.format("Tried to setCount twice for %s", this.item.getRegistryName()));
        }
        return this;
    }

    @ZenMethod
    public MCLootEntryItem setStage(@Optional String stageName) {
        if (stageName == null) {
            this.autoStage = true;
        } else {
            this.lootConditions.add(new Staged(stageName));
        }
        return this;
    }

    @ZenMethod
    public MCLootEntryItem setChance(float chance) {
        this.lootConditions.add(new RandomChance(chance));
        return this;
    }

    @ZenMethod
    public MCLootEntryItem addRandomEnchant() {
        this.lootFunctions.add((LootFunction)new EnchantRandomly(new LootCondition[0], new ArrayList()));
        return this;
    }

    @ZenMethod
    public MCLootEntryItem addEnchantWithLevels(int levels, boolean treasure) {
        this.lootFunctions.add((LootFunction)new EnchantWithLevels(new LootCondition[0], new RandomValueRange((float)levels, (float)levels), treasure));
        return this;
    }

    @ZenMethod
    public MCLootEntryItem addEnchantWithLevels(int minLevels, int maxLevels, boolean treasure) {
        this.lootFunctions.add((LootFunction)new EnchantWithLevels(new LootCondition[0], new RandomValueRange((float)minLevels, (float)maxLevels), treasure));
        return this;
    }

    @ZenMethod
    public MCLootEntryItem setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    @ZenMethod
    public MCLootEntryItem setQuality(int quality) {
        this.quality = quality;
        return this;
    }

    @ZenMethod
    public MCLootEntryItem addCondition(MCLootCondition lootCondition) {
        throw new UnsupportedOperationException();
    }

    @ZenMethod
    public MCLootEntryItem addFunction(MCLootFunction lootFunction) {
        this.lootFunctions.add(lootFunction.getInner());
        return this;
    }
}

