/*
 * Decompiled with CFR 0.152.
 */
package uk.bobbytables.zenloot.commands;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.bobbytables.zenloot.ZenLootMod;

public class CommandDumpLoot
extends CommandBase {
    public String func_71517_b() {
        return "dump";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/zenloot dump";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Logger logger = LogManager.getLogger();
        boolean errorsOccurred = false;
        File outDir = new File(server.func_71238_n(), "loot-tables");
        if (!outDir.exists()) {
            outDir.mkdir();
        }
        HashSet<ResourceLocation> allTables = new HashSet<ResourceLocation>();
        allTables.addAll(LootTableList.func_186374_a());
        allTables.addAll(ZenLootMod.UNREGISTERED_LOOT_TABLES);
        for (ResourceLocation tableId : allTables) {
            File resourceDir = new File(outDir, tableId.func_110624_b());
            String[] fileName = tableId.func_110623_a().split("/");
            if (fileName.length > 1) {
                String[] subDirs;
                for (String subDir : subDirs = Arrays.copyOfRange(fileName, 0, fileName.length - 1)) {
                    resourceDir = new File(resourceDir, subDir);
                }
            }
            if (!resourceDir.exists()) {
                resourceDir.mkdirs();
            }
            File tableFile = new File(resourceDir, String.format("%s.json", fileName[fileName.length - 1]));
            LootTable table = server.func_130014_f_().func_184146_ak().func_186521_a(tableId);
            try {
                FileWriter writer = new FileWriter(tableFile);
                Throwable throwable = null;
                try {
                    ZenLootMod.GSON_INSTANCE.toJson((Object)table, table.getClass(), (Appendable)writer);
                    ((Writer)writer).flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Writer)writer).close();
                }
            }
            catch (IOException e) {
                errorsOccurred = true;
                logger.error("Encountered an error writing {}", (Object)tableFile.getPath());
                logger.error((Object)e);
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Loot tables have been dumped!"));
        if (errorsOccurred) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Errors occurred"));
        }
    }
}

