/*
 * Decompiled with CFR 0.152.
 */
package lex.world.gen.feature;

import com.google.common.base.Predicate;
import java.util.Random;
import lex.config.Config;
import lex.world.gen.feature.Feature;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FeatureOre
extends Feature {
    private IBlockState blockToSpawn;
    private IBlockState blockToReplace;
    private int veinSize;

    public FeatureOre(Config config) {
        super(config);
        this.blockToSpawn = config.getBlock("blockToSpawn", Blocks.field_180401_cv.func_176223_P());
        this.blockToReplace = config.getBlock("blockToReplace", Blocks.field_180401_cv.func_176223_P());
        this.veinSize = config.getInt("veinSize", 8);
    }

    public FeatureOre(int genAttempts, float genProbability, boolean randomizeGenAttempts, int minGenHeight, int maxGenHeight, IBlockState blockToSpawn, IBlockState blockToReplace, int veinSize) {
        super(genAttempts, genProbability, randomizeGenAttempts, minGenHeight, maxGenHeight);
        this.blockToSpawn = blockToSpawn;
        this.blockToReplace = blockToReplace;
        this.veinSize = veinSize;
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (this.blockToSpawn.func_177230_c() == Blocks.field_180401_cv || this.blockToReplace.func_177230_c() == Blocks.field_180401_cv) {
            return false;
        }
        float f = rand.nextFloat() * (float)Math.PI;
        double d0 = (float)pos.func_177958_n() + MathHelper.func_76126_a((float)f) * (float)this.veinSize / 8.0f;
        double d1 = (float)pos.func_177958_n() - MathHelper.func_76126_a((float)f) * (float)this.veinSize / 8.0f;
        double d2 = (float)pos.func_177952_p() + MathHelper.func_76134_b((float)f) * (float)this.veinSize / 8.0f;
        double d3 = (float)pos.func_177952_p() - MathHelper.func_76134_b((float)f) * (float)this.veinSize / 8.0f;
        double d4 = pos.func_177956_o() + rand.nextInt(3) - 2;
        double d5 = pos.func_177956_o() + rand.nextInt(3) - 2;
        for (int i = 0; i < this.veinSize; ++i) {
            float f1 = (float)i / (float)this.veinSize;
            double d6 = d0 + (d1 - d0) * (double)f1;
            double d7 = d4 + (d5 - d4) * (double)f1;
            double d8 = d2 + (d3 - d2) * (double)f1;
            double d9 = rand.nextDouble() * (double)this.veinSize / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * f1)) + 1.0f) * d9 + 1.0;
            int j = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int k = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int l = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int i1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int l1 = j; l1 <= i1; ++l1) {
                double d12 = ((double)l1 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int i2 = k; i2 <= j1; ++i2) {
                    double d13 = ((double)i2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    for (int j2 = l; j2 <= k1; ++j2) {
                        BlockPos newPos;
                        IBlockState state;
                        double d14 = ((double)j2 + 0.5 - d8) / (d10 / 2.0);
                        if (!(d12 * d12 + d13 * d13 + d14 * d14 < 1.0) || !(state = world.func_180495_p(newPos = new BlockPos(l1, i2, j2))).func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, newPos, (Predicate)BlockMatcher.func_177642_a((Block)this.blockToReplace.func_177230_c())) || state != this.blockToReplace) continue;
                        world.func_180501_a(newPos, this.blockToSpawn, 2);
                    }
                }
            }
        }
        return true;
    }
}

