/*
 * Decompiled with CFR 0.152.
 */
package lex.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lex.LibEx;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class FileHelper {
    public static void copyDirectoryToDirectory(URL sourceDirectory, File destinationDirectory) {
        block7: {
            String sourcePath;
            block6: {
                sourcePath = sourceDirectory.getPath();
                if (!LibEx.IS_DEV_ENV) break block6;
                if (!sourceDirectory.getProtocol().equals("file")) break block7;
                sourcePath = sourcePath.substring(1);
                for (File file : FileUtils.listFilesAndDirs((File)new File(sourceDirectory.getFile()), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)) {
                    File destinationFile = new File(destinationDirectory, file.getPath().substring(sourcePath.length()));
                    if (destinationFile.exists()) continue;
                    if (FileHelper.getFileExtension(destinationFile).equals("")) {
                        destinationFile.mkdirs();
                        continue;
                    }
                    FileHelper.copyFile(file, destinationFile);
                }
                break block7;
            }
            if (!sourceDirectory.getProtocol().equals("jar")) break block7;
            sourcePath = sourcePath.substring(sourcePath.indexOf(".jar!/") + 6);
            try {
                JarFile zipFile = ((JarURLConnection)sourceDirectory.openConnection()).getJarFile();
                Enumeration<? extends ZipEntry> zipEntries = ((ZipFile)zipFile).entries();
                while (zipEntries.hasMoreElements()) {
                    File file;
                    ZipEntry zipEntry = zipEntries.nextElement();
                    String zipName = zipEntry.getName();
                    if (!zipName.contains(sourcePath) || (file = new File(destinationDirectory, zipName.substring(sourcePath.length()))).exists()) continue;
                    if (zipEntry.isDirectory()) {
                        file.mkdirs();
                        continue;
                    }
                    FileHelper.copyFile(((ZipFile)zipFile).getInputStream(zipEntry), new BufferedOutputStream(new FileOutputStream(file)));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getFileExtension(File file) {
        int dotIndex = file.getName().lastIndexOf(46);
        return dotIndex == -1 ? "" : file.getName().substring(dotIndex + 1);
    }

    private static void copyFile(InputStream inputStream, OutputStream outputStream) {
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void copyFile(File sourceFile, File destinationFile) {
        try {
            FileHelper.copyFile(new FileInputStream(sourceFile), new BufferedOutputStream(new FileOutputStream(destinationFile)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

