/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.noworldgen5you;

import net.darkhax.noworldgen5you.WorldgenConfig;
import net.darkhax.noworldgen5you.world.gen.MapGenEmpty;
import net.darkhax.noworldgen5you.world.gen.MapGenEndCityEmpty;
import net.darkhax.noworldgen5you.world.gen.MapGenFortressEmpty;
import net.darkhax.noworldgen5you.world.gen.MapGenMineshaftEmpty;
import net.darkhax.noworldgen5you.world.gen.MapGenOceanMonumentEmpty;
import net.darkhax.noworldgen5you.world.gen.MapGenScatteredFeaturesEmpty;
import net.darkhax.noworldgen5you.world.gen.MapGenStrongholdEmpty;
import net.darkhax.noworldgen5you.world.gen.MapGenVillageEmpty;
import net.darkhax.noworldgen5you.world.gen.MapGenWoodlandMansion;
import net.minecraft.world.gen.MapGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="noworldgen5you", name="No Worldgen 5 You", version="1.0.6", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", acceptedMinecraftVersions="[1.12.2]")
public class NoWorldgen5You {
    private static final Logger LOG = LogManager.getLogger((String)"No Worldgen 5 You");
    private static MapGenScatteredFeaturesEmpty SCATTERED_GEN;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        WorldgenConfig.initConfig(event.getSuggestedConfigurationFile());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
        SCATTERED_GEN = new MapGenScatteredFeaturesEmpty();
    }

    @SubscribeEvent
    public void onChunkPopulated(PopulateChunkEvent.Populate event) {
        if (WorldgenConfig.isPopulateDisabled(event.getType().name().toLowerCase())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onMapGen(InitMapGenEvent event) {
        if (!WorldgenConfig.isStructureDisabled(event.getType().name().toLowerCase())) {
            return;
        }
        switch (event.getType()) {
            case CAVE: {
                event.setNewGen((MapGenBase)new MapGenEmpty());
                break;
            }
            case CUSTOM: {
                LOG.info("Attempting to replace {} with an empty map generator. If this causes a ClassCastException report it to the author of that mod and not the author of NoWorldgen5You");
                event.setNewGen((MapGenBase)new MapGenEmpty());
                break;
            }
            case MINESHAFT: {
                event.setNewGen((MapGenBase)new MapGenMineshaftEmpty());
                break;
            }
            case NETHER_BRIDGE: {
                event.setNewGen((MapGenBase)new MapGenFortressEmpty());
                break;
            }
            case NETHER_CAVE: {
                event.setNewGen((MapGenBase)new MapGenEmpty());
                break;
            }
            case OCEAN_MONUMENT: {
                event.setNewGen((MapGenBase)new MapGenOceanMonumentEmpty());
                break;
            }
            case RAVINE: {
                event.setNewGen((MapGenBase)new MapGenEmpty());
                break;
            }
            case SCATTERED_FEATURE: {
                event.setNewGen((MapGenBase)SCATTERED_GEN);
                break;
            }
            case STRONGHOLD: {
                event.setNewGen((MapGenBase)new MapGenStrongholdEmpty());
                break;
            }
            case VILLAGE: {
                event.setNewGen((MapGenBase)new MapGenVillageEmpty());
                break;
            }
            case END_CITY: {
                event.setNewGen((MapGenBase)new MapGenEndCityEmpty());
                break;
            }
            case WOODLAND_MANSION: {
                event.setNewGen((MapGenBase)new MapGenWoodlandMansion());
                break;
            }
        }
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        LOG.warn("Invalid fingerprint detected! The file " + event.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!");
    }
}

