/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.jaff.entities;

import com.tmtravlr.jaff.ConfigOptions;
import com.tmtravlr.jaff.JAFFMod;
import com.tmtravlr.jaff.advancements.CatchFishMobTrigger;
import com.tmtravlr.jaff.advancements.FishBucketTrigger;
import com.tmtravlr.jaff.entities.EntityFish;
import com.tmtravlr.jaff.items.ItemFishBucket;
import com.tmtravlr.jaff.items.ItemHookedFishingRod;
import com.tmtravlr.jaff.network.SToCMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.management.PlayerList;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityIronFishHook
extends EntityFishHook {
    private static final DataParameter<Integer> DATA_HOOKED_ENTITY = EntityDataManager.func_187226_a(EntityFishHook.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean inGround;
    private int ticksInGround = 0;
    private int ticksInAir;
    private int ticksCatchable;
    private int ticksCaughtDelay;
    private int ticksCatchableDelay;
    private float fishApproachAngle;
    private State currentState = State.FLYING;
    private int luckModifier;
    private int lureModifier;
    public int strain = 0;

    @Deprecated
    public EntityIronFishHook(World world) {
        this(world, EntityIronFishHook.tryToGetPlayer(world));
    }

    @SideOnly(value=Side.CLIENT)
    public EntityIronFishHook(World world, EntityPlayer player, double x, double y, double z) {
        super(world, player, x, y, z);
        this.field_70178_ae = true;
    }

    public EntityIronFishHook(World world, EntityPlayer player) {
        super(world, player);
        this.field_70178_ae = true;
    }

    public void func_191516_a(int lureToSet) {
        this.lureModifier = lureToSet;
    }

    public void func_191517_b(int luckToSet) {
        this.luckModifier = luckToSet;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_HOOKED_ENTITY, (Object)0);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (DATA_HOOKED_ENTITY.equals(key)) {
            int i = (Integer)this.func_184212_Q().func_187225_a(DATA_HOOKED_ENTITY);
            this.field_146043_c = i > 0 ? this.field_70170_p.func_73045_a(i - 1) : null;
        }
        super.func_184206_a(key);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (this.field_146043_c instanceof EntityFish) {
            if (this.strain > -80) {
                --this.strain;
            } else {
                this.func_70106_y();
                return;
            }
        }
        if (this.func_190619_l() == null) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.shouldStopFishing()) {
            if (this.inGround) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                    return;
                }
            }
            float f = 0.0f;
            BlockPos blockpos = new BlockPos((Entity)this);
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            if (iblockstate.func_185904_a().func_76224_d()) {
                f = BlockLiquid.func_190973_f((IBlockState)iblockstate, (IBlockAccess)this.field_70170_p, (BlockPos)blockpos);
            }
            if (this.currentState != State.HOOKED_IN_ENTITY && this.field_146043_c != null) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                this.currentState = State.HOOKED_IN_ENTITY;
                return;
            }
            if (this.currentState == State.FLYING) {
                if (f > 0.0f) {
                    this.field_70159_w *= 0.3;
                    this.field_70181_x *= 0.2;
                    this.field_70179_y *= 0.3;
                    this.currentState = State.BOBBING;
                    return;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.checkCollision();
                }
                if (!(this.inGround || this.field_70122_E || this.field_70123_F)) {
                    ++this.ticksInAir;
                } else {
                    this.ticksInAir = 0;
                    this.field_70159_w = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70179_y = 0.0;
                }
            } else {
                if (this.currentState == State.HOOKED_IN_ENTITY) {
                    if (this.field_146043_c != null) {
                        if (this.field_146043_c.field_70128_L) {
                            this.field_146043_c = null;
                            this.currentState = State.FLYING;
                        } else {
                            this.field_70165_t = this.field_146043_c.field_70165_t;
                            double d2 = this.field_146043_c.field_70131_O;
                            this.field_70163_u = this.field_146043_c.func_174813_aQ().field_72338_b + d2 * 0.8;
                            this.field_70161_v = this.field_146043_c.field_70161_v;
                            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        }
                    }
                    return;
                }
                if (this.currentState == State.BOBBING) {
                    this.field_70159_w *= 0.9;
                    this.field_70179_y *= 0.9;
                    double d0 = this.field_70163_u + this.field_70181_x - (double)blockpos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.field_70181_x -= d0 * (double)this.field_70146_Z.nextFloat() * 0.2;
                    if (!this.field_70170_p.field_72995_K && f > 0.0f && iblockstate.func_185904_a() == Material.field_151586_h) {
                        this.catchingFish(blockpos);
                    }
                }
            }
            if (!iblockstate.func_185904_a().func_76224_d()) {
                this.field_70181_x -= 0.03;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.updateRotation();
            double d1 = 0.92;
            this.field_70159_w *= 0.92;
            this.field_70181_x *= 0.92;
            this.field_70179_y *= 0.92;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int func_146034_e() {
        if (this.field_146043_c instanceof EntityFish) {
            if (this.strain < 0) {
                this.strain = 0;
            }
            this.strain += ((EntityFish)this.field_146043_c).getStrain();
        }
        if (this.field_70170_p.field_72995_K || this.func_190619_l() == null) return 0;
        int toReturn = 0;
        if (this.field_146043_c != null && this.field_146043_c instanceof EntityFish) {
            double d0 = this.func_190619_l().field_70165_t - this.field_70165_t;
            double d2 = this.func_190619_l().field_70163_u - this.field_70163_u;
            double d4 = this.func_190619_l().field_70161_v - this.field_70161_v;
            double d6 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2 + d4 * d4));
            double strength = 0.1;
            ItemStack rod = this.getFishingRod();
            if (rod.func_77973_b() instanceof ItemHookedFishingRod) {
                strength = ((ItemHookedFishingRod)rod.func_77973_b()).strength;
            }
            Vec3d pullVector = new Vec3d(d0, d2, d4);
            this.field_146043_c.func_70024_g(pullVector.field_72450_a * strength, pullVector.field_72448_b * strength + (double)MathHelper.func_76133_a((double)d6) * 0.08, pullVector.field_72449_c * strength);
            if (!ConfigOptions.simpleFishing && !this.fishIsCatchable()) return 0;
            this.catchFish((EntityFish)this.field_146043_c);
            this.func_190619_l().func_71064_a(StatList.field_188071_E, 1);
            toReturn = 1;
        } else {
            if (this.field_146043_c != null) {
                this.func_184527_k();
                this.field_70170_p.func_72960_a((Entity)this, (byte)31);
                toReturn = this.field_146043_c instanceof EntityItem ? 3 : 5;
            } else if (this.ticksCatchable > 0) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_70170_p);
                lootcontext$builder.func_186469_a((float)this.luckModifier + this.func_190619_l().func_184817_da());
                for (ItemStack itemstack : this.field_70170_p.func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(this.field_70146_Z, lootcontext$builder.func_186471_a())) {
                    EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, itemstack);
                    double d0 = this.func_190619_l().field_70165_t - this.field_70165_t;
                    double d1 = this.func_190619_l().field_70163_u - this.field_70163_u;
                    double d2 = this.func_190619_l().field_70161_v - this.field_70161_v;
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    double d4 = 0.1;
                    entityitem.field_70159_w = d0 * 0.1;
                    entityitem.field_70181_x = d1 * 0.1 + (double)MathHelper.func_76133_a((double)d3) * 0.08;
                    entityitem.field_70179_y = d2 * 0.1;
                    this.field_70170_p.func_72838_d((Entity)entityitem);
                    this.func_190619_l().field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.func_190619_l().field_70170_p, this.func_190619_l().field_70165_t, this.func_190619_l().field_70163_u + 0.5, this.func_190619_l().field_70161_v + 0.5, this.field_70146_Z.nextInt(6) + 1));
                    Item item = itemstack.func_77973_b();
                    if (item != Items.field_151115_aP && item != Items.field_179566_aV) continue;
                    this.func_190619_l().func_71064_a(StatList.field_188071_E, 1);
                }
                toReturn = 1;
            }
            if (this.inGround) {
                toReturn = 2;
            }
        }
        this.func_70106_y();
        return toReturn;
    }

    private boolean fishIsCatchable() {
        return new Vec3d(this.func_190619_l().field_70165_t, this.func_190619_l().field_70163_u, this.func_190619_l().field_70161_v).func_72438_d(new Vec3d(this.field_146043_c.field_70165_t, this.field_146043_c.field_70163_u, this.field_146043_c.field_70161_v)) < 3.0;
    }

    private List<ItemStack> getDroppedItems(EntityFish fish) {
        float chance = this.field_70170_p.field_73012_v.nextFloat();
        LootContext.Builder builder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)fish);
        builder.func_186469_a((float)EnchantmentHelper.func_191529_b((ItemStack)this.func_190619_l().func_184614_ca()) + this.func_190619_l().func_184817_da());
        return this.field_70170_p.func_184146_ak().func_186521_a(fish.getDropLootTable()).func_186462_a(this.field_70146_Z, builder.func_186471_a());
    }

    private void catchFish(EntityFish fish) {
        ItemStack fishBucket;
        if (ItemFishBucket.canFishGoInBucket(fish) && !(fishBucket = ItemFishBucket.createFromFish(fish)).func_190926_b()) {
            Item pickupItem = fishBucket.func_77973_b().func_77668_q();
            int bucketIndex = -1;
            for (int i = 0; i < 9 && bucketIndex == -1; ++i) {
                if (((ItemStack)this.func_190619_l().field_71071_by.field_70462_a.get(i)).func_190926_b() || ((ItemStack)this.func_190619_l().field_71071_by.field_70462_a.get(i)).func_77973_b() != pickupItem) continue;
                bucketIndex = i;
            }
            if (bucketIndex != -1) {
                this.func_190619_l().field_71071_by.func_70299_a(bucketIndex, fishBucket);
                PacketBuffer out = new PacketBuffer(Unpooled.buffer());
                out.writeInt(5);
                out.writeInt(bucketIndex);
                out.func_150788_a(fishBucket);
                SToCMessage packet = new SToCMessage((ByteBuf)out);
                JAFFMod.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)this.func_190619_l());
                FishBucketTrigger.instance.trigger((EntityPlayerMP)this.func_190619_l());
                fish.func_70106_y();
                return;
            }
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)JAFFMod.rodFireAspect, (ItemStack)this.getFishingRod()) > 0) {
            fish.func_70015_d(15);
        }
        if (!fish.func_70631_g_()) {
            for (ItemStack dropItem : this.getDroppedItems(fish)) {
                if (fish.func_145818_k_()) {
                    dropItem.func_151001_c(fish.func_95999_t());
                }
                EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, dropItem);
                double d1 = this.func_190619_l().field_70165_t - this.field_70165_t;
                double d3 = this.func_190619_l().field_70163_u - this.field_70163_u;
                double d5 = this.func_190619_l().field_70161_v - this.field_70161_v;
                double d7 = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3 + d5 * d5));
                double d9 = 0.1;
                entityitem.field_70159_w = d1 * d9;
                entityitem.field_70181_x = d3 * d9 + (double)MathHelper.func_76133_a((double)d7) * 0.08;
                entityitem.field_70179_y = d5 * d9;
                this.field_70170_p.func_72838_d((Entity)entityitem);
                this.func_190619_l().field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.func_190619_l().field_70170_p, this.func_190619_l().field_70165_t, this.func_190619_l().field_70163_u + 0.5, this.func_190619_l().field_70161_v + 0.5, this.field_70146_Z.nextInt(6) + 1));
            }
            CatchFishMobTrigger.instance.trigger((EntityPlayerMP)this.func_190619_l());
        }
        fish.func_70106_y();
    }

    private void removeBaitFromRod() {
        ItemStack rod = this.func_190619_l().func_184614_ca();
        if (rod.func_77942_o()) {
            NBTTagCompound tag = rod.func_77978_p();
            NBTTagList baitList = tag.func_150295_c("Bait", 10);
            for (int i = 0; i < baitList.func_74745_c(); ++i) {
                NBTTagCompound baitTag = baitList.func_150305_b(i);
                String type = baitTag.func_74779_i("Type");
                if (!((EntityFish)this.field_146043_c).isBreedingItem(type)) continue;
                baitTag.func_74768_a("Count", baitTag.func_74762_e("Count") - 1);
                if (baitTag.func_74762_e("Count") <= 0) {
                    baitList.func_74744_a(i);
                }
                return;
            }
        }
    }

    public void hookEntity(Entity entity) {
        this.field_146043_c = entity;
        this.setHookedEntity();
        if (entity instanceof EntityFish) {
            this.removeBaitFromRod();
        }
    }

    public ItemStack getFishingRod() {
        ItemStack stack = this.func_190619_l().func_184614_ca();
        if (stack.func_77973_b() instanceof ItemHookedFishingRod) {
            return stack;
        }
        stack = this.func_190619_l().func_184592_cb();
        if (stack.func_77973_b() instanceof ItemHookedFishingRod) {
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private boolean shouldStopFishing() {
        ItemStack fishingRod = this.getFishingRod();
        if (!this.func_190619_l().field_70128_L && this.func_190619_l().func_70089_S() && !fishingRod.func_190926_b() && this.func_70068_e((Entity)this.func_190619_l()) <= 1024.0) {
            return false;
        }
        this.func_70106_y();
        return true;
    }

    private void updateRotation() {
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
    }

    private void checkCollision() {
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d, vec3d1, false, true, false);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72321_a(1.0, 1.0, 1.0));
        double d0 = 0.0;
        for (Entity entity1 : list) {
            double d1;
            if (!this.func_189739_a(entity1) || entity1 == this.func_190619_l() && this.ticksInAir < 5) continue;
            double expansion = 0.3f;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72321_a(expansion, expansion, expansion);
            RayTraceResult raytraceresult1 = axisalignedbb.func_72327_a(vec3d, vec3d1);
            if (raytraceresult1 == null || !((d1 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (entity != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && raytraceresult.field_72313_a != RayTraceResult.Type.MISS) {
            if (raytraceresult.field_72313_a == RayTraceResult.Type.ENTITY) {
                this.hookEntity(raytraceresult.field_72308_g);
            } else {
                this.inGround = true;
            }
        }
    }

    private void setHookedEntity() {
        this.func_184212_Q().func_187227_b(DATA_HOOKED_ENTITY, (Object)(this.field_146043_c.func_145782_y() + 1));
    }

    private void catchingFish(BlockPos posCatching) {
        WorldServer worldserver = (WorldServer)this.field_70170_p;
        int i = 1;
        BlockPos blockpos = posCatching.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.25f && this.field_70170_p.func_175727_C(blockpos)) {
            ++i;
        }
        if (this.field_70146_Z.nextFloat() < 0.5f && !this.field_70170_p.func_175678_i(blockpos)) {
            --i;
        }
        if (this.ticksCatchable > 0) {
            --this.ticksCatchable;
            if (this.ticksCatchable <= 0) {
                this.ticksCaughtDelay = 0;
                this.ticksCatchableDelay = 0;
            } else {
                this.field_70181_x -= 0.2 * (double)this.field_70146_Z.nextFloat() * (double)this.field_70146_Z.nextFloat();
            }
        } else if (this.ticksCatchableDelay > 0) {
            this.ticksCatchableDelay -= i;
            if (this.ticksCatchableDelay > 0) {
                double d2;
                this.fishApproachAngle = (float)((double)this.fishApproachAngle + this.field_70146_Z.nextGaussian() * 4.0);
                float f = this.fishApproachAngle * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                double d0 = this.field_70165_t + (double)(f1 * (float)this.ticksCatchableDelay * 0.1f);
                double d1 = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                Block block = worldserver.func_180495_p(new BlockPos(d0, d1 - 1.0, d2 = this.field_70161_v + (double)(f2 * (float)this.ticksCatchableDelay * 0.1f))).func_177230_c();
                if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        worldserver.func_175739_a(EnumParticleTypes.WATER_BUBBLE, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0, new int[0]);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    worldserver.func_175739_a(EnumParticleTypes.WATER_WAKE, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0, new int[0]);
                    worldserver.func_175739_a(EnumParticleTypes.WATER_WAKE, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0, new int[0]);
                }
            } else {
                this.field_70181_x = -0.4f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f);
                this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                double d3 = this.func_174813_aQ().field_72338_b + 0.5;
                worldserver.func_175739_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f, new int[0]);
                worldserver.func_175739_a(EnumParticleTypes.WATER_WAKE, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.field_70130_N * 20.0f), (double)this.field_70130_N, 0.0, (double)this.field_70130_N, (double)0.2f, new int[0]);
                this.ticksCatchable = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)40);
            }
        } else if (this.ticksCaughtDelay > 0) {
            this.ticksCaughtDelay -= i;
            float f5 = 0.15f;
            if (this.ticksCaughtDelay < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.ticksCaughtDelay) * 0.05);
            } else if (this.ticksCaughtDelay < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.ticksCaughtDelay) * 0.02);
            } else if (this.ticksCaughtDelay < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.ticksCaughtDelay) * 0.01);
            }
            if (this.field_70146_Z.nextFloat() < f5) {
                double d6;
                double d5;
                float f6 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
                double d4 = this.field_70165_t + (double)(MathHelper.func_76126_a((float)f6) * f7 * 0.1f);
                Block block1 = worldserver.func_180495_p(new BlockPos((int)d4, (int)(d5 = (double)((float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f)) - 1, (int)(d6 = this.field_70161_v + (double)(MathHelper.func_76134_b((float)f6) * f7 * 0.1f)))).func_177230_c();
                if (block1 == Blocks.field_150355_j || block1 == Blocks.field_150358_i) {
                    worldserver.func_175739_a(EnumParticleTypes.WATER_SPLASH, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0, new int[0]);
                }
            }
            if (this.ticksCaughtDelay <= 0) {
                this.fishApproachAngle = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
                this.ticksCatchableDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
            }
        } else {
            this.ticksCaughtDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)600);
            this.ticksCaughtDelay -= this.lureModifier * 20 * 5;
        }
    }

    private static EntityPlayer tryToGetPlayer(World world) {
        PlayerList players;
        if (world.field_72995_K) {
            return JAFFMod.proxy.getPlayer();
        }
        if (FMLCommonHandler.instance().getMinecraftServerInstance() != null && !(players = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al()).func_181057_v().isEmpty()) {
            return (EntityPlayer)players.func_181057_v().get(0);
        }
        throw new IllegalStateException("Can't create an iron fish hook without a player.");
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

