/*
 * Decompiled with CFR 0.152.
 */
package com.seth0067.tothebatpoles;

import com.google.common.base.Optional;
import com.seth0067.tothebatpoles.Main;
import com.seth0067.tothebatpoles.Message;
import com.seth0067.tothebatpoles.Pole;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.MovementInput;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Holder
extends Entity {
    public static boolean allowClimbing = false;
    public static boolean switchToThirdPersonView = true;
    public static float slideAcceleration = 0.04f;
    public static float maxSpinVelocity = 0.1f;
    public static float maxSlideVelocity = 0.4f;
    public static final String NAME = Holder.class.getSimpleName().toLowerCase(Locale.ROOT);
    private static final float MAX_DELTA_YAW = 105.0f;
    private static final Vec3d UP_UNIT_VECTOR = new Vec3d(0.0, 1.0, 0.0);
    private static final DataParameter<Optional<BlockPos>> POLE_POS = EntityDataManager.func_187226_a(Holder.class, (DataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Float> SPIN_RADIUS = EntityDataManager.func_187226_a(Holder.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SPIN_VELOCITY = EntityDataManager.func_187226_a(Holder.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SLIDE_ACCELERATION = EntityDataManager.func_187226_a(Holder.class, (DataSerializer)DataSerializers.field_187193_c);
    private float deltaRotation;
    private int savedThirdPersonView;

    public Holder(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70180_af.func_187214_a(POLE_POS, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SLIDE_ACCELERATION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SPIN_RADIUS, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SPIN_VELOCITY, (Object)Float.valueOf(0.0f));
    }

    public Holder(World world, EntityPlayer player, BlockPos polePos) {
        this(world);
        this.func_82149_j((Entity)player);
        player.func_184205_a((Entity)this, false);
        this.setPolePos(polePos);
        this.setSpinRadius(player.field_70130_N * 0.8f);
    }

    public void updateSpinVelocity(float deltaYaw) {
        float yawFactor = deltaYaw / 105.0f;
        float spinVelocity = maxSpinVelocity * yawFactor;
        this.setSpinVelocity(spinVelocity);
    }

    public void updateSlideAcceleration(boolean decelerate) {
        float targetVelocity = decelerate ? (allowClimbing ? maxSlideVelocity / 2.0f : 0.0f) : -maxSlideVelocity;
        float acceleration = MathHelper.func_76131_a((float)((float)((double)targetVelocity - this.field_70181_x)), (float)(-slideAcceleration), (float)slideAcceleration);
        this.setSlideAcceleration(acceleration);
    }

    public AxisAlignedBB func_174813_aQ() {
        return super.func_174813_aQ();
    }

    public double func_70042_X() {
        return 0.0;
    }

    @Nullable
    public Entity func_184179_bs() {
        List passengers = this.func_184188_bt();
        return passengers.isEmpty() ? null : (Entity)passengers.get(0);
    }

    public boolean isServerSide() {
        return !this.isClientSide();
    }

    public boolean isClientSide() {
        return this.func_130014_f_().field_72995_K;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean iamThePassenger(Entity passenger) {
        return Minecraft.func_71410_x().field_71439_g == passenger;
    }

    public void func_70071_h_() {
        this.field_70122_E = true;
        World world = this.func_130014_f_();
        Entity passenger = this.func_184179_bs();
        BlockPos polePos = this.getPolePos();
        if (!(passenger instanceof EntityPlayer) || polePos == null || !Pole.isPoleBlock(world, polePos) || Pole.isBottomBlock(world, polePos)) {
            if (this.isServerSide()) {
                this.func_70106_y();
            }
            return;
        }
        passenger.field_70122_E = true;
        if (polePos.func_177956_o() != this.func_180425_c().func_177956_o()) {
            polePos = new BlockPos(polePos.func_177958_n(), this.func_180425_c().func_177956_o(), polePos.func_177952_p());
            this.setPolePos(polePos);
        }
        if (this.isClientSide()) {
            boolean decelerate = false;
            if (passenger instanceof EntityPlayerSP && this.iamThePassenger(passenger)) {
                MovementInput input = ((EntityPlayerSP)passenger).field_71158_b;
                if (input.field_78901_c) {
                    decelerate = true;
                }
            }
            float headYaw = passenger.func_70079_am();
            float holderYaw = this.field_70177_z;
            float deltaYaw = MathHelper.func_76142_g((float)(headYaw - holderYaw));
            Message message = new Message(this, decelerate, deltaYaw);
            Main.NETWORK.sendToServer((IMessage)message);
        }
        Vec3d poleCenter = Pole.getCenterWithY(polePos, this.field_70163_u);
        Vec3d radiusVec = this.func_174791_d().func_178788_d(poleCenter).func_72432_b();
        float spinVelocity = this.getSpinVelocity();
        Vec3d spinVec = radiusVec.func_72431_c(UP_UNIT_VECTOR).func_186678_a((double)spinVelocity);
        float spinRadius = this.getSpinRadius();
        float slideAcceleration = this.getSlideAcceleration();
        this.field_70181_x += (double)slideAcceleration;
        Vec3d destPos = poleCenter.func_178787_e(radiusVec.func_186678_a((double)spinRadius)).func_178787_e(spinVec).func_72441_c(0.0, this.field_70181_x, 0.0);
        float yaw = 180.0f - (float)(MathHelper.func_181159_b((double)radiusVec.field_72450_a, (double)radiusVec.field_72449_c) * 57.29577951308232);
        this.deltaRotation = MathHelper.func_76142_g((float)(yaw - this.field_70177_z));
        this.func_70080_a(destPos.field_72450_a, destPos.field_72448_b, destPos.field_72449_c, yaw, this.field_70125_A);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        passenger.field_70177_z += this.deltaRotation;
        passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
        this.func_184190_l(passenger);
    }

    public void func_184190_l(Entity entity) {
        entity.func_181013_g(this.field_70177_z);
        float delta = MathHelper.func_76142_g((float)(entity.field_70177_z - this.field_70177_z));
        float clamped = MathHelper.func_76131_a((float)delta, (float)-105.0f, (float)105.0f);
        entity.field_70177_z += clamped - delta;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean shouldRiderSit() {
        return true;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public float getSpinRadius() {
        return ((Float)this.field_70180_af.func_187225_a(SPIN_RADIUS)).floatValue();
    }

    public void setSpinRadius(float spinRadius) {
        this.field_70180_af.func_187227_b(SPIN_RADIUS, (Object)Float.valueOf(spinRadius));
    }

    public float getSpinVelocity() {
        return ((Float)this.field_70180_af.func_187225_a(SPIN_VELOCITY)).floatValue();
    }

    public void setSpinVelocity(float spinVelocity) {
        this.field_70180_af.func_187227_b(SPIN_VELOCITY, (Object)Float.valueOf(spinVelocity));
    }

    public float getSlideAcceleration() {
        return ((Float)this.field_70180_af.func_187225_a(SLIDE_ACCELERATION)).floatValue();
    }

    public void setSlideAcceleration(float slideAcceleration) {
        this.field_70180_af.func_187227_b(SLIDE_ACCELERATION, (Object)Float.valueOf(slideAcceleration));
    }

    @Nullable
    public BlockPos getPolePos() {
        return (BlockPos)((Optional)this.field_70180_af.func_187225_a(POLE_POS)).orNull();
    }

    public void setPolePos(@Nullable BlockPos pos) {
        this.field_70180_af.func_187227_b(POLE_POS, (Object)Optional.fromNullable((Object)pos));
    }

    protected void func_184200_o(Entity passenger) {
        if (this.isClientSide() && switchToThirdPersonView && this.iamThePassenger(passenger)) {
            GameSettings settings = Minecraft.func_71410_x().field_71474_y;
            this.savedThirdPersonView = settings.field_74320_O;
            if (settings.field_74320_O == 0) {
                settings.field_74320_O = 1;
            }
        }
        super.func_184200_o(passenger);
    }

    protected void func_184225_p(Entity passenger) {
        if (this.isClientSide() && switchToThirdPersonView && this.iamThePassenger(passenger)) {
            Minecraft.func_71410_x().field_71474_y.field_74320_O = this.savedThirdPersonView;
        }
        super.func_184225_p(passenger);
    }

    public static class Renderer
    extends Render<Holder> {
        protected Renderer(RenderManager renderManager) {
            super(renderManager);
        }

        @Nullable
        protected ResourceLocation getEntityTexture(Holder entity) {
            return null;
        }

        public void doRender(Holder entity, double x, double y, double z, float entityYaw, float partialTicks) {
            super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        }

        public static class Factory
        implements IRenderFactory<Holder> {
            public Render<? super Holder> createRenderFor(RenderManager manager) {
                return new Renderer(manager);
            }
        }
    }
}

