/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot.pattern.parameter;

import buildcraft.api.core.render.ISprite;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.builders.BCBuildersSprites;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.StackUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum PatternParameterHollow implements IStatementParameter
{
    FILLED_INNER(true, false),
    FILLED_OUTER(true, true),
    HOLLOW(false, false);

    public final boolean filled;
    public final boolean outerFilled;

    private PatternParameterHollow(boolean filled, boolean outerFilled) {
        this.filled = filled;
        this.outerFilled = outerFilled;
    }

    public static PatternParameterHollow readFromNbt(NBTTagCompound nbt) {
        if (nbt.func_74767_n("filled")) {
            if (nbt.func_74767_n("outer")) {
                return FILLED_OUTER;
            }
            return FILLED_INNER;
        }
        return HOLLOW;
    }

    public void writeToNbt(NBTTagCompound compound) {
        compound.func_74757_a("filled", this.filled);
        if (this.filled) {
            compound.func_74757_a("outer", this.outerFilled);
        }
    }

    public String getUniqueTag() {
        return "buildcraft:fillerParameterHollow";
    }

    @SideOnly(value=Side.CLIENT)
    public ISprite getSprite() {
        if (this.filled) {
            if (this.outerFilled) {
                return BCBuildersSprites.PARAM_FILLED_OUTER;
            }
            return BCBuildersSprites.PARAM_FILLED_INNER;
        }
        return BCBuildersSprites.PARAM_HOLLOW;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return StackUtil.EMPTY;
    }

    public String getDescription() {
        String after = this.filled ? (this.outerFilled ? "filled_outer" : "filled") : "hollow";
        return LocaleUtil.localize((String)("fillerpattern.parameter." + after));
    }

    public PatternParameterHollow onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        return null;
    }

    public IStatementParameter rotateLeft() {
        return this;
    }

    public PatternParameterHollow[] getPossible(IStatementContainer source) {
        return PatternParameterHollow.values();
    }
}

