/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot.pattern.parameter;

import buildcraft.api.core.render.ISprite;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.builders.BCBuildersSprites;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.misc.StackUtil;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum PatternParameterFacing implements IStatementParameter
{
    DOWN(EnumFacing.DOWN),
    UP(EnumFacing.UP),
    NORTH(EnumFacing.NORTH),
    SOUTH(EnumFacing.SOUTH),
    WEST(EnumFacing.WEST),
    EAST(EnumFacing.EAST);

    public final EnumFacing face;
    private static final Map<EnumFacing, PatternParameterFacing> faceToParam;

    private PatternParameterFacing(EnumFacing face) {
        this.face = face;
    }

    public static PatternParameterFacing readFromNbt(NBTTagCompound nbt) {
        return PatternParameterFacing.values()[MathUtil.clamp((int)nbt.func_74771_c("v"), (int)0, (int)6)];
    }

    public static PatternParameterFacing get(EnumFacing face) {
        return faceToParam.get(face);
    }

    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74774_a("v", (byte)this.ordinal());
    }

    public String getUniqueTag() {
        return "buildcraft:fillerParameterFacing";
    }

    @SideOnly(value=Side.CLIENT)
    public ISprite getSprite() {
        return (ISprite)BCBuildersSprites.PARAM_FACE.get(this.face);
    }

    @Nonnull
    public ItemStack getItemStack() {
        return StackUtil.EMPTY;
    }

    public String getDescription() {
        return LocaleUtil.localize((String)("buildcraft.param.facing." + this.face.func_176610_l()));
    }

    public PatternParameterFacing onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        return null;
    }

    public IStatementParameter rotateLeft() {
        return this;
    }

    public IStatementParameter[] getPossible(IStatementContainer source) {
        return PatternParameterFacing.values();
    }

    public boolean isPossibleOrdered() {
        return false;
    }

    static {
        faceToParam = new EnumMap<EnumFacing, PatternParameterFacing>(EnumFacing.class);
        for (PatternParameterFacing param : PatternParameterFacing.values()) {
            faceToParam.put(param.face, param);
        }
    }
}

