/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot.pattern;

import buildcraft.api.core.render.ISprite;
import buildcraft.api.filler.IFilledTemplate;
import buildcraft.api.filler.IFillerPatternShape;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.builders.BCBuildersSprites;
import buildcraft.builders.snapshot.Snapshot;
import buildcraft.builders.snapshot.pattern.Pattern;
import buildcraft.builders.snapshot.pattern.parameter.PatternParameterFacing;
import buildcraft.builders.snapshot.pattern.parameter.PatternParameterHollow;
import buildcraft.builders.snapshot.pattern.parameter.PatternParameterRotation;
import buildcraft.lib.misc.VecUtil;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Locale;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;

public final class PatternSpherePart
extends Pattern
implements IFillerPatternShape {
    private final SpherePartType type;

    public PatternSpherePart(SpherePartType type) {
        super("sphere_" + type.lowerCaseName);
        this.type = type;
    }

    public int minParameters() {
        return this.type.openFaces == 1 ? 2 : 3;
    }

    public int maxParameters() {
        return this.minParameters();
    }

    public IStatementParameter createParameter(int index) {
        if (index >= this.minParameters()) {
            return null;
        }
        switch (index) {
            case 0: {
                return PatternParameterHollow.FILLED_INNER;
            }
            case 1: {
                return PatternParameterFacing.DOWN;
            }
            case 2: {
                return PatternParameterRotation.NONE;
            }
        }
        return null;
    }

    public ISprite getSprite() {
        return (ISprite)BCBuildersSprites.FILLER_SPHERE_PART.get((Object)this.type);
    }

    public boolean fillTemplate(IFilledTemplate filledTemplate, IStatementParameter[] params) {
        PatternParameterFacing facing = (PatternParameterFacing)PatternSpherePart.getParam((int)1, (IStatementParameter[])params, (IStatementParameter)PatternParameterFacing.DOWN);
        PatternParameterRotation rotation = (PatternParameterRotation)PatternSpherePart.getParam((int)2, (IStatementParameter[])params, (IStatementParameter)PatternParameterRotation.NONE);
        PatternParameterHollow hollow = (PatternParameterHollow)PatternSpherePart.getParam((int)0, (IStatementParameter[])params, (IStatementParameter)PatternParameterHollow.FILLED_INNER);
        EnumSet<EnumFacing> innerSides = EnumSet.noneOf(EnumFacing.class);
        Vec3d max = new Vec3d((double)filledTemplate.getMax().func_177958_n(), (double)filledTemplate.getMax().func_177956_o(), (double)filledTemplate.getMax().func_177952_p());
        Vec3d center = VecUtil.scale((Vec3d)max, (double)0.5);
        Vec3d radius = center.func_72441_c(0.5, 0.5, 0.5);
        innerSides.add(facing.face);
        EnumFacing.Axis axis = facing.face.func_176740_k();
        Vec3d offset = VecUtil.offset((Vec3d)Vec3d.field_186680_a, (EnumFacing)facing.face, (double)VecUtil.getValue((Vec3d)radius, (EnumFacing.Axis)axis));
        center = center.func_178787_e(offset);
        radius = VecUtil.replaceValue((Vec3d)radius, (EnumFacing.Axis)axis, (double)(VecUtil.getValue((Vec3d)radius, (EnumFacing.Axis)axis) * 2.0));
        if (this.type.openFaces > 1) {
            EnumFacing.Axis secondaryAxis = rotation.rotationCount % 2 == 1 ? (axis == EnumFacing.Axis.X ? EnumFacing.Axis.Y : (axis == EnumFacing.Axis.Y ? EnumFacing.Axis.Z : EnumFacing.Axis.X)) : (axis == EnumFacing.Axis.X ? EnumFacing.Axis.Z : (axis == EnumFacing.Axis.Y ? EnumFacing.Axis.X : EnumFacing.Axis.Y));
            EnumFacing secondaryFace = VecUtil.getFacing((EnumFacing.Axis)secondaryAxis, (rotation.rotationCount >= 2 ? 1 : 0) != 0);
            innerSides.add(secondaryFace);
            offset = VecUtil.offset((Vec3d)Vec3d.field_186680_a, (EnumFacing)secondaryFace, (double)VecUtil.getValue((Vec3d)radius, (EnumFacing.Axis)secondaryAxis));
            center = center.func_178787_e(offset);
            radius = VecUtil.replaceValue((Vec3d)radius, (EnumFacing.Axis)secondaryAxis, (double)(VecUtil.getValue((Vec3d)radius, (EnumFacing.Axis)secondaryAxis) * 2.0));
            if (this.type.openFaces > 2) {
                int rotationCount = rotation.rotationCount + 1 & 3;
                EnumFacing.Axis tertiaryAxis = rotationCount % 2 == 1 ? (axis == EnumFacing.Axis.X ? EnumFacing.Axis.Y : (axis == EnumFacing.Axis.Y ? EnumFacing.Axis.Z : EnumFacing.Axis.X)) : (axis == EnumFacing.Axis.X ? EnumFacing.Axis.Z : (axis == EnumFacing.Axis.Y ? EnumFacing.Axis.X : EnumFacing.Axis.Y));
                EnumFacing tertiaryFace = VecUtil.getFacing((EnumFacing.Axis)tertiaryAxis, (rotationCount >= 2 ? 1 : 0) != 0);
                innerSides.add(tertiaryFace);
                offset = VecUtil.offset((Vec3d)Vec3d.field_186680_a, (EnumFacing)tertiaryFace, (double)VecUtil.getValue((Vec3d)radius, (EnumFacing.Axis)tertiaryAxis));
                center = center.func_178787_e(offset);
                radius = VecUtil.replaceValue((Vec3d)radius, (EnumFacing.Axis)tertiaryAxis, (double)(VecUtil.getValue((Vec3d)radius, (EnumFacing.Axis)tertiaryAxis) * 2.0));
            }
        }
        double cx = center.field_72450_a;
        double cy = center.field_72448_b;
        double cz = center.field_72449_c;
        double rx = radius.field_72450_a;
        double ry = radius.field_72448_b;
        double rz = radius.field_72449_c;
        BitSet data = null;
        if (hollow != PatternParameterHollow.FILLED_INNER) {
            data = new BitSet(Snapshot.getDataSize(filledTemplate.getSize()));
        }
        for (int x = 0; x <= filledTemplate.getMax().func_177958_n(); ++x) {
            double dx = Math.abs((double)x - cx) / rx;
            double dxx = dx * dx;
            for (int y = 0; y <= filledTemplate.getMax().func_177956_o(); ++y) {
                double dy = Math.abs((double)y - cy) / ry;
                double dyy = dy * dy;
                for (int z = 0; z <= filledTemplate.getMax().func_177952_p(); ++z) {
                    double dz = Math.abs((double)z - cz) / rz;
                    double dzz = dz * dz;
                    if (!(dxx + dyy + dzz < 1.0)) continue;
                    if (hollow != PatternParameterHollow.FILLED_INNER) {
                        data.set(Snapshot.posToIndex(filledTemplate.getSize(), x, y, z), true);
                        continue;
                    }
                    filledTemplate.set(x, y, z, true);
                }
            }
        }
        boolean outerFilled = hollow.outerFilled;
        if (hollow != PatternParameterHollow.FILLED_INNER) {
            int z;
            int x;
            for (x = 0; x <= filledTemplate.getMax().func_177958_n(); ++x) {
                block4: for (int y = 0; y <= filledTemplate.getMax().func_177956_o(); ++y) {
                    int z2;
                    if (!innerSides.contains(EnumFacing.NORTH)) {
                        for (z2 = 0; z2 <= filledTemplate.getMax().func_177952_p(); ++z2) {
                            if (data.get(Snapshot.posToIndex(filledTemplate.getSize(), x, y, z2))) {
                                filledTemplate.set(x, y, z2, true);
                                break;
                            }
                            if (!outerFilled) continue;
                            filledTemplate.set(x, y, z2, true);
                        }
                    }
                    if (innerSides.contains(EnumFacing.SOUTH)) continue;
                    for (z2 = filledTemplate.getMax().func_177952_p(); z2 >= 0; --z2) {
                        if (data.get(Snapshot.posToIndex(filledTemplate.getSize(), x, y, z2))) {
                            filledTemplate.set(x, y, z2, true);
                            continue block4;
                        }
                        if (!outerFilled) continue;
                        filledTemplate.set(x, y, z2, true);
                    }
                }
            }
            for (x = 0; x <= filledTemplate.getMax().func_177958_n(); ++x) {
                block8: for (z = 0; z <= filledTemplate.getMax().func_177952_p(); ++z) {
                    int y;
                    if (!innerSides.contains(EnumFacing.DOWN)) {
                        for (y = 0; y <= filledTemplate.getMax().func_177956_o(); ++y) {
                            if (data.get(Snapshot.posToIndex(filledTemplate.getSize(), x, y, z))) {
                                filledTemplate.set(x, y, z, true);
                                break;
                            }
                            if (!outerFilled) continue;
                            filledTemplate.set(x, y, z, true);
                        }
                    }
                    if (innerSides.contains(EnumFacing.UP)) continue;
                    for (y = filledTemplate.getMax().func_177956_o(); y >= 0; --y) {
                        if (data.get(Snapshot.posToIndex(filledTemplate.getSize(), x, y, z))) {
                            filledTemplate.set(x, y, z, true);
                            continue block8;
                        }
                        if (!outerFilled) continue;
                        filledTemplate.set(x, y, z, true);
                    }
                }
            }
            for (int y = 0; y <= filledTemplate.getMax().func_177956_o(); ++y) {
                block12: for (z = 0; z <= filledTemplate.getMax().func_177952_p(); ++z) {
                    int x2;
                    if (!innerSides.contains(EnumFacing.WEST)) {
                        for (x2 = 0; x2 <= filledTemplate.getMax().func_177958_n(); ++x2) {
                            if (data.get(Snapshot.posToIndex(filledTemplate.getSize(), x2, y, z))) {
                                filledTemplate.set(x2, y, z, true);
                                break;
                            }
                            if (!outerFilled) continue;
                            filledTemplate.set(x2, y, z, true);
                        }
                    }
                    if (innerSides.contains(EnumFacing.EAST)) continue;
                    for (x2 = filledTemplate.getMax().func_177958_n(); x2 >= 0; --x2) {
                        if (data.get(Snapshot.posToIndex(filledTemplate.getSize(), x2, y, z))) {
                            filledTemplate.set(x2, y, z, true);
                            continue block12;
                        }
                        if (!outerFilled) continue;
                        filledTemplate.set(x2, y, z, true);
                    }
                }
            }
        }
        return true;
    }

    public static enum SpherePartType {
        EIGHTH(3),
        QUARTER(2),
        HALF(1);

        public final String lowerCaseName = this.name().toLowerCase(Locale.ROOT);
        final int openFaces;

        private SpherePartType(int numOpenFaces) {
            this.openFaces = numOpenFaces;
        }
    }
}

