/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.data;

import java.util.List;
import net.gobbob.mobends.client.event.DataUpdateHandler;
import net.gobbob.mobends.client.event.EventHandlerRenderPlayer;
import net.gobbob.mobends.data.Data_Player;
import net.gobbob.mobends.data.Data_Skeleton;
import net.gobbob.mobends.data.Data_Spider;
import net.gobbob.mobends.data.Data_Zombie;
import net.gobbob.mobends.data.EntityDatabase;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.util.vector.Vector3f;

public abstract class EntityData {
    public static final int PLAYER_DATA = 0;
    public static final int SKELETON_DATA = 1;
    public static final int SPIDER_DATA = 2;
    public static final int ZOMBIE_DATA = 3;
    public static EntityDatabase[] databases = new EntityDatabase[]{new EntityDatabase(Data_Player.class), new EntityDatabase(Data_Skeleton.class), new EntityDatabase(Data_Spider.class), new EntityDatabase(Data_Zombie.class)};
    public int entityID;
    public String entityType;
    public ModelBase model;
    public Vector3f position = new Vector3f();
    public Vector3f motion_prev = new Vector3f();
    public Vector3f motion = new Vector3f();
    private boolean initialized = false;
    public float ticks = 0.0f;
    public boolean updatedThisFrame = false;
    public float ticksAfterLiftoff = 0.0f;
    public float ticksAfterTouchdown = 0.0f;
    public float ticksAfterPunch = 0.0f;
    public float ticksAfterThrowup = 0.0f;
    public boolean alreadyPunched = false;
    public float climbingCycle = 0.0f;
    public boolean onGround = true;
    public boolean climbing = false;

    public EntityData(int argEntityID) {
        this.entityID = argEntityID;
        this.entityType = Minecraft.func_71410_x().field_71441_e.func_73045_a(argEntityID) != null ? Minecraft.func_71410_x().field_71441_e.func_73045_a(argEntityID).func_70005_c_() : "NULL";
        this.model = null;
    }

    public static void add(int databaseId, EntityData data) {
        databases[databaseId].addEntry(data.entityID, data);
    }

    public static void addNew(int databaseId, int entityId) {
        databases[databaseId].newEntry(entityId);
    }

    public static void remove(int databaseId, int entityId) {
        databases[databaseId].removeEntry(entityId);
    }

    public static EntityData get(int databaseId, int entityId) {
        EntityData data = databases[databaseId].getEntry(entityId);
        if (data == null) {
            data = databases[databaseId].newEntry(entityId);
        }
        return data;
    }

    public boolean canBeUpdated() {
        return !this.updatedThisFrame && (!Minecraft.func_71410_x().field_71441_e.field_72995_K || !Minecraft.func_71410_x().func_147113_T());
    }

    public boolean calcOnGround() {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityID);
        if (entity == null) {
            return false;
        }
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ();
        double var1 = this.position.y + this.motion.y;
        int i = 0;
        List list = entity.field_70170_p.func_184144_a(entity, entity.func_174813_aQ().func_72317_d(0.0, (double)-0.025f, 0.0));
        return i < list.size();
    }

    public boolean calcCollidedHorizontally() {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityID);
        if (entity == null) {
            return false;
        }
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ();
        int i = 0;
        List list = entity.field_70170_p.func_184144_a(entity, entity.func_174813_aQ().func_72317_d((double)this.motion.x, 0.0, (double)this.motion.z));
        return i < list.size();
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public void update(float argPartialTicks) {
        if (this.getEntity() == null) {
            return;
        }
        if (this.ticks > (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + argPartialTicks) {
            this.onTicksRestart();
            this.ticks = (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + argPartialTicks;
        }
        this.ticks = (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + argPartialTicks;
        this.updatedThisFrame = false;
        if (this.calcOnGround() & !this.onGround) {
            this.onTouchdown();
            this.onGround = true;
        }
        if (!this.calcOnGround() & this.onGround | (this.motion_prev.y <= 0.0f && this.motion.y - this.motion_prev.y > 0.4f && this.ticksAfterLiftoff > 2.0f)) {
            this.onLiftoff();
            this.onGround = false;
        }
        if (this.calcClimbing()) {
            this.climbingCycle += DataUpdateHandler.ticksPerFrame * this.motion.y * 2.6f;
            this.climbing = true;
        }
        if (this.getEntity().field_70733_aJ > 0.0f) {
            if (!this.alreadyPunched) {
                this.onPunch();
                this.alreadyPunched = true;
            }
        } else {
            this.alreadyPunched = false;
        }
        if (this.motion_prev.y <= 0.0f && this.motion.y > 0.0f) {
            this.onThrowup();
        }
        if (!this.isOnGround()) {
            this.ticksAfterLiftoff += DataUpdateHandler.ticksPerFrame;
        }
        if (this.isOnGround()) {
            this.ticksAfterTouchdown += DataUpdateHandler.ticksPerFrame;
        }
        this.ticksAfterPunch += DataUpdateHandler.ticksPerFrame;
        this.ticksAfterThrowup += DataUpdateHandler.ticksPerFrame;
    }

    public EntityLivingBase getEntity() {
        if (Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityID) instanceof EntityLivingBase) {
            return (EntityLivingBase)Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityID);
        }
        return null;
    }

    public void onTicksRestart() {
    }

    public void onTouchdown() {
        this.ticksAfterTouchdown = 0.0f;
    }

    public void onLiftoff() {
        this.ticksAfterLiftoff = 0.0f;
    }

    public void onThrowup() {
        this.ticksAfterThrowup = 0.0f;
    }

    public void onPunch() {
        this.ticksAfterPunch = 0.0f;
    }

    public float getClimbingRotation() {
        EnumFacing facing = this.getLadderFacing();
        if (facing == EnumFacing.NORTH) {
            return 0.0f;
        }
        if (facing == EnumFacing.SOUTH) {
            return 180.0f;
        }
        if (facing == EnumFacing.WEST) {
            return -90.0f;
        }
        if (facing == EnumFacing.EAST) {
            return 90.0f;
        }
        return 0.0f;
    }

    public EnumFacing getLadderFacing() {
        EntityLivingBase entity = this.getEntity();
        BlockPos position = new BlockPos(Math.floor(entity.field_70165_t), Math.floor(entity.field_70163_u), Math.floor(entity.field_70161_v));
        IBlockState block = entity.field_70170_p.func_180495_p(position);
        IBlockState blockBelow = entity.field_70170_p.func_180495_p(position.func_177982_a(0, -1, 0));
        IBlockState blockBelow2 = entity.field_70170_p.func_180495_p(position.func_177982_a(0, -2, 0));
        if (block.func_177230_c() instanceof BlockLadder) {
            return (EnumFacing)block.func_177229_b((IProperty)BlockLadder.field_176382_a);
        }
        if (blockBelow.func_177230_c() instanceof BlockLadder) {
            return (EnumFacing)blockBelow.func_177229_b((IProperty)BlockLadder.field_176382_a);
        }
        if (blockBelow2.func_177230_c() instanceof BlockLadder) {
            return (EnumFacing)blockBelow2.func_177229_b((IProperty)BlockLadder.field_176382_a);
        }
        return EnumFacing.NORTH;
    }

    public boolean calcClimbing() {
        EntityLivingBase entity = this.getEntity();
        if (entity == null || entity.field_70170_p == null) {
            return false;
        }
        BlockPos position = new BlockPos(Math.floor(entity.field_70165_t), Math.floor(entity.field_70163_u), Math.floor(entity.field_70161_v));
        IBlockState block = entity.field_70170_p.func_180495_p(position);
        IBlockState blockBelow = entity.field_70170_p.func_180495_p(position.func_177982_a(0, -1, 0));
        IBlockState blockBelow2 = entity.field_70170_p.func_180495_p(position.func_177982_a(0, -2, 0));
        return entity.func_70617_f_() && !this.isOnGround() && (block.func_177230_c() instanceof BlockLadder || blockBelow.func_177230_c() instanceof BlockLadder || blockBelow2.func_177230_c() instanceof BlockLadder);
    }

    public float getLedgeHeight() {
        EntityLivingBase entity = this.getEntity();
        float clientY = (float)(entity.field_70163_u + (entity.field_70163_u - entity.field_70167_r) * (double)EventHandlerRenderPlayer.partialTicks);
        BlockPos position = new BlockPos(Math.floor(entity.field_70165_t), Math.floor(entity.field_70163_u), Math.floor(entity.field_70161_v));
        IBlockState block = entity.field_70170_p.func_180495_p(position.func_177982_a(0, 2, 0));
        IBlockState blockBelow = entity.field_70170_p.func_180495_p(position.func_177982_a(0, 1, 0));
        IBlockState blockBelow2 = entity.field_70170_p.func_180495_p(position.func_177982_a(0, 0, 0));
        if (!(block.func_177230_c() instanceof BlockLadder)) {
            if (!(blockBelow.func_177230_c() instanceof BlockLadder)) {
                if (!(blockBelow2.func_177230_c() instanceof BlockLadder)) {
                    return clientY - (float)((int)clientY) + 2.0f;
                }
                return clientY - (float)((int)clientY) + 1.0f;
            }
            return clientY - (float)((int)clientY);
        }
        return -2.0f;
    }

    public boolean isClimbing() {
        return this.climbing;
    }

    public float getLookAngle() {
        EntityLivingBase entity = this.getEntity();
        Vec3d vec3 = entity.func_70040_Z();
        double x = vec3.field_72450_a;
        double z = vec3.field_72449_c;
        if (x * x + z * z == 0.0) {
            return 0.0f;
        }
        return (float)(Math.atan2(x, z) / Math.PI * 180.0);
    }

    public float getMovementAngle() {
        float lookAngle = this.getLookAngle();
        double x = this.motion.x;
        double z = this.motion.z;
        if (x * x + z * z == 0.0) {
            return 0.0f;
        }
        float worldMoveAngle = (float)(Math.atan2(x, z) / Math.PI * 180.0);
        return worldMoveAngle - lookAngle;
    }

    public boolean isStrafing() {
        float threshold;
        float angle = this.getMovementAngle();
        return angle >= (threshold = 30.0f) && angle <= 180.0f - threshold || angle >= -180.0f + threshold && angle <= -threshold;
    }

    public float getMovementSpeed() {
        return this.motion.length();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean flag) {
        this.initialized = flag;
    }

    public abstract void initModelPose();
}

