/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.client.gui.packeditor;

import java.util.ArrayList;
import java.util.List;
import net.gobbob.mobends.client.gui.packeditor.GuiPackEditor;
import net.gobbob.mobends.client.gui.packeditor.GuiPackEntry;
import net.gobbob.mobends.util.Draw;
import net.minecraft.client.Minecraft;

public class GuiPackTab {
    public static final int WIDTH = 18;
    public static final int HEIGHT = 16;
    public static final int OFFSET = 15;
    protected int x;
    protected int y;
    protected int index;
    protected String title;
    protected List<GuiPackEntry> entries;
    protected boolean hover;

    public GuiPackTab(int index, String title) {
        this.index = index;
        this.title = title;
        this.hover = false;
        this.entries = new ArrayList<GuiPackEntry>();
    }

    public void initGui(int x, int y) {
        this.x = x + this.index * 15;
        this.y = y - 20;
        int yOffset = y;
        for (GuiPackEntry entry : this.entries) {
            entry.initGui(x + 5, yOffset - 1);
            yOffset += 33;
        }
    }

    public void update(int mouseX, int mouseY) {
        this.hover = mouseX >= this.x && mouseX <= this.x + 18 && mouseY >= this.y && mouseY <= this.y + 16;
    }

    public void display(int mouseX, int mouseY, boolean selected) {
        this.update(mouseX, mouseY);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiPackEditor.BACKGROUND_TEXTURE);
        int textureY = selected ? 149 : (this.hover ? 133 : 117);
        Draw.texturedModalRect(this.x, this.y + (selected ? 0 : 1), this.index * 18, textureY, 18, 16);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        this.update(mouseX, mouseY);
        return this.hover;
    }

    public List<GuiPackEntry> getEntries() {
        return this.entries;
    }

    public void addEntry(GuiPackEntry guiPackEntry) {
        this.entries.add(guiPackEntry);
    }

    public String getTitle() {
        return this.title;
    }
}

