/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.client.gui.packeditor;

import java.io.File;
import net.gobbob.mobends.client.gui.elements.GuiCompactTextField;
import net.gobbob.mobends.client.gui.elements.GuiCustomButton;
import net.gobbob.mobends.client.gui.packeditor.GuiPackEntry;
import net.gobbob.mobends.client.gui.packeditor.GuiPackList;
import net.gobbob.mobends.pack.BendsPack;
import net.gobbob.mobends.pack.PackManager;
import net.gobbob.mobends.util.Draw;
import net.gobbob.mobends.util.GUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class GuiPackEditor {
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("mobends", "textures/gui/pack_editor.png");
    public static final int EDITOR_WIDTH = 248;
    public static final int EDITOR_HEIGHT = 177;
    public static final String publicInfoText = "Want your creation to be featured? Contact me at:";
    protected int x;
    protected int y;
    protected GuiCompactTextField titleTextField;
    protected GuiCustomButton openFolderButton;
    protected GuiCustomButton useButton;
    protected GuiCustomButton editButton;
    protected GuiCustomButton doneButton;
    protected GuiPackList packList;
    protected boolean editMode;
    protected String generatedName;
    protected FontRenderer fontRenderer;
    float publicJumbotronTransition = 1.0f;
    long time;
    long lastTime;

    public GuiPackEditor() {
        this.titleTextField = new GuiCompactTextField(Minecraft.func_71410_x().field_71466_p, 120, 14);
        this.openFolderButton = new GuiCustomButton(130, 20);
        this.useButton = new GuiCustomButton(60, 20);
        this.editButton = new GuiCustomButton(60, 20);
        this.doneButton = new GuiCustomButton(60, 20);
        this.useButton.field_146125_m = false;
        this.doneButton.field_146125_m = false;
        this.editButton.field_146125_m = false;
        this.packList = new GuiPackList(this);
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.titleTextField.func_146189_e(false);
        this.populate();
        this.time = System.nanoTime() / 1000L;
        this.lastTime = System.nanoTime() / 1000L;
    }

    public void initGui(int x, int y) {
        this.x = x - 124;
        this.y = y - 88;
        this.titleTextField.setPosition(this.x + 123, this.y + 39);
        this.packList.initGui(this.x + 5, this.y + 19);
        this.updatePositions();
    }

    public void updatePositions() {
        String useButtonTitle = "mobends.gui.use";
        if (this.packList.getSelectedEntry() != null && this.packList.getSelectedEntry().isApplied()) {
            useButtonTitle = "mobends.gui.disable";
        }
        this.useButton.setPosition(this.x + 248 - 57, this.y + 177 - 17).setText(I18n.func_135052_a((String)useButtonTitle, (Object[])new Object[0]));
        this.editButton.setPosition(this.x + 248 - 128, this.y + 177 - 17).setText(I18n.func_135052_a((String)"mobends.gui.edit", (Object[])new Object[0]));
        this.doneButton.setPosition(this.x + 248 - 57, this.y + 177 - 17).setText(I18n.func_135052_a((String)"mobends.gui.done", (Object[])new Object[0]));
        this.openFolderButton.setPosition(this.x + 248 - 128, this.y + 177 - 17).setText(I18n.func_135052_a((String)"mobends.gui.openpacksfolder", (Object[])new Object[0]));
    }

    public void update(int mouseX, int mouseY) {
        if (this.titleTextField.func_146206_l()) {
            this.titleTextField.func_146178_a();
        }
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        this.titleTextField.func_146192_a(mouseX, mouseY, button);
        this.packList.mouseClicked(mouseX, mouseY, button);
        if (this.openFolderButton.mousePressed(mouseX, mouseY)) {
            OpenGlHelper.func_188786_a((File)PackManager.localDirectory);
        }
        if (this.useButton.mousePressed(mouseX, mouseY)) {
            if (this.packList.getSelectedEntry().isApplied()) {
                this.packList.getSelectedEntry().setApplied(false);
            } else {
                this.packList.usePack(this.packList.getSelectedEntry());
            }
            this.updatePositions();
        }
        if (this.editButton.mousePressed(mouseX, mouseY)) {
            this.setEditMode(true);
        }
        if (this.doneButton.mousePressed(mouseX, mouseY)) {
            this.packList.getSelectedEntry().displayName = this.titleTextField.func_146179_b();
            this.packList.getSelectedEntry().name = this.generatedName;
            this.setEditMode(false);
        }
        return false;
    }

    public void handleMouseInput() {
        this.packList.handleMouseInput();
    }

    public void display(int mouseX, int mouseY, float partialTicks) {
        this.time = System.nanoTime() / 1000L;
        float delta = (this.time - this.lastTime) / 1000L;
        this.lastTime = this.time;
        if (this.publicJumbotronTransition > 0.0f) {
            this.publicJumbotronTransition -= delta * 0.001f;
        }
        if (this.publicJumbotronTransition < 0.0f) {
            this.publicJumbotronTransition = 0.0f;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        Draw.borderBox(this.x + 4, this.y + 4, 248, 177, 4, 102, 13);
        Draw.texturedModalRect(this.x + 4 + 124 - 75, this.y - 13, 106, 0, 150, 13);
        this.drawCenteredString(this.fontRenderer, I18n.func_135052_a((String)"mobends.gui.packs", (Object[])new Object[0]), this.x + 4 + 124, this.y - 9, 0xFFFFFF);
        this.packList.display(mouseX, mouseY);
        this.titleTextField.func_146194_f();
        this.openFolderButton.drawButton(mouseX, mouseY, partialTicks);
        this.useButton.drawButton(mouseX, mouseY, partialTicks);
        this.editButton.drawButton(mouseX, mouseY, partialTicks);
        this.doneButton.drawButton(mouseX, mouseY, partialTicks);
        GuiPackEntry entry = this.packList.getSelectedEntry();
        if (this.packList.getSelectedTab().index == 0) {
            if (entry != null) {
                String packName = entry.displayName;
                String packAuthor = "by " + entry.author;
                this.fontRenderer.func_175063_a(packName, (float)(this.x + 184 - this.fontRenderer.func_78256_a(packName) / 2), (float)(this.y + 7), 0xFFFFFF);
                this.fontRenderer.func_78276_b(packAuthor, this.x + 184 - this.fontRenderer.func_78256_a(packAuthor) / 2, this.y + 17, 0x444444);
                int yOffset = this.y + 29;
                for (String line : GUtil.squashText(this.fontRenderer, entry.description, 130)) {
                    this.fontRenderer.func_175063_a(line, (float)(this.x + 120), (float)yOffset, 0xFFFFFF);
                    yOffset += 12;
                }
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
                Draw.texturedModalRect(this.x + 124 - 4, this.y + 6, 0, 195, 130, 61);
                float alpha = GUtil.clamp(this.publicJumbotronTransition * 2.0f, 0.0f, 1.0f);
                int color = 0xFFFFFF;
                Draw.rectangle(this.x + 124 - 4, this.y + 6, 130, 61, color |= ((int)(alpha * 255.0f) & 0xFF) << 24);
                int yOffset = this.y + 77;
                for (String line : GUtil.squashText(this.fontRenderer, publicInfoText, 130)) {
                    this.fontRenderer.func_78276_b(line, this.x + 121, yOffset, 0x444444);
                    yOffset += 12;
                }
                this.fontRenderer.func_175063_a("gobbobminecraft@gmail.com", (float)(this.x + 118), (float)(this.y + 110), 0xFFFFFF);
            }
        } else {
            this.openFolderButton.drawButton(mouseX, mouseY, partialTicks);
            if (!this.editMode) {
                if (entry != null) {
                    String text = entry.displayName;
                    this.fontRenderer.func_175063_a(text, (float)(this.x + 184 - this.fontRenderer.func_78256_a(text) / 2), (float)(this.y + 7), 0xFFFFFF);
                    int yOffset = this.y + 27;
                    for (String line : GUtil.squashText(this.fontRenderer, entry.description, 80)) {
                        this.fontRenderer.func_175063_a(line, (float)(this.x + 120), (float)yOffset, 0xFFFFFF);
                        yOffset += 12;
                    }
                } else {
                    String text = I18n.func_135052_a((String)"mobends.gui.selectpack", (Object[])new Object[0]);
                    this.fontRenderer.func_175063_a(text, (float)(this.x + 184 - this.fontRenderer.func_78256_a(text) / 2), (float)(this.y + 88), 0xFFFFFF);
                }
            } else {
                this.fontRenderer.func_175063_a(I18n.func_135052_a((String)"mobends.gui.entername", (Object[])new Object[0]), (float)(this.x + 125), (float)(this.y + 25), 0xFFFFFF);
                this.fontRenderer.func_175063_a(I18n.func_135052_a((String)"mobends.gui.filename", (Object[])new Object[0]) + ": ", (float)(this.x + 125), (float)(this.y + 58), 0xFFFFFF);
                this.fontRenderer.func_78276_b(this.generatedName, this.x + 125, this.y + 70, 0x777777);
            }
        }
    }

    private void drawCenteredString(FontRenderer fontRendererIn, String text, int x, int y, int color) {
        fontRendererIn.func_175063_a(text, (float)(x - fontRendererIn.func_78256_a(text) / 2), (float)y, color);
    }

    public void keyTyped(char typedChar, int keyCode) {
        if (this.titleTextField.func_146201_a(typedChar, keyCode)) {
            this.generatedName = BendsPack.constructName(this.titleTextField.func_146179_b()) + ".bends";
        }
    }

    public void populate() {
        PackManager.updatePublicDatabase();
        this.packList.populate();
    }

    public void setEditMode(boolean value) {
        if (this.editMode != value) {
            this.editMode = value;
            if (this.editMode) {
                this.titleTextField.func_146189_e(true);
                this.titleTextField.func_146180_a(this.packList.getSelectedEntry().displayName);
                this.editButton.field_146125_m = false;
                this.useButton.field_146125_m = false;
                this.doneButton.field_146125_m = true;
                this.generatedName = BendsPack.constructName(this.packList.getSelectedEntry().displayName) + ".bends";
            } else {
                this.titleTextField.func_146189_e(false);
                this.editButton.field_146125_m = true;
                this.useButton.field_146125_m = true;
                this.doneButton.field_146125_m = false;
            }
        }
    }

    public void onEntrySelected(GuiPackEntry entry, boolean update) {
        if (entry != null) {
            this.useButton.field_146125_m = true;
            switch (this.packList.tabId) {
                case 0: {
                    this.editButton.field_146125_m = false;
                    break;
                }
                case 1: {
                    this.editButton.field_146125_m = true;
                }
            }
            this.openFolderButton.field_146125_m = false;
        } else {
            this.useButton.field_146125_m = false;
            this.editButton.field_146125_m = false;
            this.openFolderButton.field_146125_m = true;
        }
        this.setEditMode(false);
        if (update) {
            this.updatePositions();
        }
    }

    public void apply() {
        this.packList.apply();
    }

    public GuiPackList getPackList() {
        return this.packList;
    }

    public void onOpened() {
        this.publicJumbotronTransition = 1.0f;
    }
}

