/*
 * Decompiled with CFR 0.152.
 */
package net.gobbob.mobends.animatedentity;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.gobbob.mobends.animatedentity.alterentry.AlterEntry;
import net.gobbob.mobends.animation.Animation;
import net.gobbob.mobends.animation.player.Animation_Attack;
import net.gobbob.mobends.animation.player.Animation_Axe;
import net.gobbob.mobends.animation.player.Animation_Bow;
import net.gobbob.mobends.animation.player.Animation_Climbing;
import net.gobbob.mobends.animation.player.Animation_Elytra;
import net.gobbob.mobends.animation.player.Animation_Guard;
import net.gobbob.mobends.animation.player.Animation_Jump;
import net.gobbob.mobends.animation.player.Animation_Mining;
import net.gobbob.mobends.animation.player.Animation_Riding;
import net.gobbob.mobends.animation.player.Animation_Sneak;
import net.gobbob.mobends.animation.player.Animation_Sprint;
import net.gobbob.mobends.animation.player.Animation_Swimming;
import net.gobbob.mobends.animation.skeleton.Animation_Walk;
import net.gobbob.mobends.animation.spider.Animation_OnGround;
import net.gobbob.mobends.animation.spider.Animation_WallClimb;
import net.gobbob.mobends.animation.zombie.Animation_Stand;
import net.gobbob.mobends.client.renderer.entity.RenderBendsCaveSpider;
import net.gobbob.mobends.client.renderer.entity.RenderBendsHusk;
import net.gobbob.mobends.client.renderer.entity.RenderBendsPlayer;
import net.gobbob.mobends.client.renderer.entity.RenderBendsSkeleton;
import net.gobbob.mobends.client.renderer.entity.RenderBendsSpectralArrow;
import net.gobbob.mobends.client.renderer.entity.RenderBendsSpider;
import net.gobbob.mobends.client.renderer.entity.RenderBendsStray;
import net.gobbob.mobends.client.renderer.entity.RenderBendsTippedArrow;
import net.gobbob.mobends.client.renderer.entity.RenderBendsWitherSkeleton;
import net.gobbob.mobends.client.renderer.entity.RenderBendsZombie;
import net.gobbob.mobends.util.BendsLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class AnimatedEntity {
    public static HashMap<String, AnimatedEntity> animatedEntities = new HashMap();
    public static Map skinMap = Maps.newHashMap();
    public static RenderBendsPlayer playerRenderer;
    private String name;
    private String displayName;
    public Class<? extends Entity> entityClass;
    public Render renderer;
    public HashMap animations = new HashMap();
    private List<AlterEntry> alterEntries = new ArrayList<AlterEntry>();
    private String[] alterableParts;
    private List<String> alterableAnimations;

    public AnimatedEntity(String argID, String argDisplayName, Class<? extends Entity> argClass, Render argRenderer, String[] alterableParts) {
        this.name = argID;
        this.displayName = argDisplayName;
        this.entityClass = argClass;
        this.renderer = argRenderer;
        this.alterableParts = alterableParts;
        this.addAlterEntry(new AlterEntry(this, this.getDisplayName()));
        this.alterableAnimations = new ArrayList<String>();
    }

    public AnimatedEntity add(Animation animation) {
        this.animations.put(animation.getName(), animation);
        this.alterableAnimations.addAll(Arrays.asList(animation.getAlterableList()));
        return this;
    }

    public AnimatedEntity addAlterEntry(AlterEntry alterEntry) {
        this.alterEntries.add(alterEntry);
        return this;
    }

    public List<AlterEntry> getAlredEntries() {
        return this.alterEntries;
    }

    public AlterEntry getAlterEntry(int index) {
        return this.alterEntries.get(index);
    }

    public String[] getAlterableParts() {
        return this.alterableParts;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public static void register(Configuration config) {
        BendsLogger.info("Registering Animated Entities...");
        animatedEntities.clear();
        AnimatedEntity.registerEntity(config, new AnimatedEntity("player", "Player", EntityPlayer.class, (Render)new RenderBendsPlayer(Minecraft.func_71410_x().func_175598_ae()), new String[]{"head", "body", "leftArm", "rightArm", "leftForeArm", "rightForeArm", "leftLeg", "rightLeg", "leftForeLeg", "rightForeLeg", "playerRotation", "leftItemRotation", "rightItemRotation"}).add(new net.gobbob.mobends.animation.player.Animation_Stand()).add(new net.gobbob.mobends.animation.player.Animation_Walk()).add(new Animation_Sneak()).add(new Animation_Sprint()).add(new Animation_Jump()).add(new Animation_Swimming()).add(new Animation_Climbing()).add(new Animation_Elytra()).add(new Animation_Guard()).add(new Animation_Bow()).add(new Animation_Riding()).add(new Animation_Mining()).add(new Animation_Attack()).add(new Animation_Axe()));
        AnimatedEntity.registerEntity(config, new AnimatedEntity("zombie", "Zombie", EntityZombie.class, (Render)new RenderBendsZombie(Minecraft.func_71410_x().func_175598_ae()), new String[]{"head", "body", "leftArm", "rightArm", "leftForeArm", "rightForeArm", "leftLeg", "rightLeg", "leftForeLeg", "rightForeLeg"}).add(new Animation_Stand()).add(new net.gobbob.mobends.animation.zombie.Animation_Walk()));
        AnimatedEntity.registerEntity(config, new AnimatedEntity("husk", "Husk", EntityHusk.class, (Render)new RenderBendsHusk(Minecraft.func_71410_x().func_175598_ae()), new String[]{"head", "body", "leftArm", "rightArm", "leftForeArm", "rightForeArm", "leftLeg", "rightLeg", "leftForeLeg", "rightForeLeg"}).add(new Animation_Stand()).add(new net.gobbob.mobends.animation.zombie.Animation_Walk()));
        AnimatedEntity.registerEntity(config, new AnimatedEntity("spider", "Spider", EntitySpider.class, (Render)new RenderBendsSpider(Minecraft.func_71410_x().func_175598_ae()), new String[]{"head", "body", "neck", "leg1", "leg2", "leg3", "leg4", "leg5", "leg6", "leg7", "leg8", "foreLeg1", "foreLeg2", "foreLeg3", "foreLeg4", "foreLeg5", "foreLeg6", "foreLeg7", "foreLeg8"}).add(new Animation_OnGround()).add(new net.gobbob.mobends.animation.spider.Animation_Jump()).add(new Animation_WallClimb()));
        AnimatedEntity.registerEntity(config, new AnimatedEntity("cave_spider", "Cave Spider", EntityCaveSpider.class, (Render)new RenderBendsCaveSpider(Minecraft.func_71410_x().func_175598_ae()), new String[]{"head", "body", "neck", "leg1", "leg2", "leg3", "leg4", "leg5", "leg6", "leg7", "leg8", "foreLeg1", "foreLeg2", "foreLeg3", "foreLeg4", "foreLeg5", "foreLeg6", "foreLeg7", "foreLeg8"}).add(new Animation_OnGround()).add(new net.gobbob.mobends.animation.spider.Animation_Jump()).add(new Animation_WallClimb()));
        AnimatedEntity.registerEntity(config, new AnimatedEntity("skeleton", "Skeleton", EntitySkeleton.class, (Render)new RenderBendsSkeleton(Minecraft.func_71410_x().func_175598_ae()), new String[]{"head", "body", "leftArm", "rightArm", "leftForeArm", "rightForeArm", "leftLeg", "rightLeg", "leftForeLeg", "rightForeLeg"}).add(new net.gobbob.mobends.animation.skeleton.Animation_Stand()).add(new Animation_Walk()).add(new net.gobbob.mobends.animation.skeleton.Animation_Bow()).add(new net.gobbob.mobends.animation.skeleton.Animation_Attack()));
        AnimatedEntity.registerEntity(config, new AnimatedEntity("wither_skeleton", "Wither Skeleton", EntityWitherSkeleton.class, (Render)new RenderBendsWitherSkeleton(Minecraft.func_71410_x().func_175598_ae()), new String[]{"head", "body", "leftArm", "rightArm", "leftForeArm", "rightForeArm", "leftLeg", "rightLeg", "leftForeLeg", "rightForeLeg"}).add(new net.gobbob.mobends.animation.skeleton.Animation_Stand()).add(new Animation_Walk()).add(new net.gobbob.mobends.animation.skeleton.Animation_Bow()).add(new net.gobbob.mobends.animation.skeleton.Animation_Attack()));
        AnimatedEntity.registerEntity(config, new AnimatedEntity("stray", "Stray", EntityStray.class, (Render)new RenderBendsStray(Minecraft.func_71410_x().func_175598_ae()), new String[]{"head", "body", "leftArm", "rightArm", "leftForeArm", "rightForeArm", "leftLeg", "rightLeg", "leftForeLeg", "rightForeLeg"}).add(new net.gobbob.mobends.animation.skeleton.Animation_Stand()).add(new Animation_Walk()).add(new net.gobbob.mobends.animation.skeleton.Animation_Bow()).add(new net.gobbob.mobends.animation.skeleton.Animation_Attack()));
        RenderingRegistry.registerEntityRenderingHandler(EntitySpectralArrow.class, (Render)new RenderBendsSpectralArrow(Minecraft.func_71410_x().func_175598_ae()));
        RenderingRegistry.registerEntityRenderingHandler(EntityTippedArrow.class, (Render)new RenderBendsTippedArrow(Minecraft.func_71410_x().func_175598_ae()));
        playerRenderer = new RenderBendsPlayer(Minecraft.func_71410_x().func_175598_ae());
        skinMap.put("default", playerRenderer);
        skinMap.put("slim", new RenderBendsPlayer(Minecraft.func_71410_x().func_175598_ae(), true));
    }

    public static void registerEntity(Configuration config, AnimatedEntity argEntity) {
        BendsLogger.info("Registering " + argEntity.displayName);
        for (int a = 0; a < argEntity.alterEntries.size(); ++a) {
            AlterEntry alterEntry = argEntity.alterEntries.get(a);
            alterEntry.setAnimate(config.get("Animated", alterEntry.getName(), true).getBoolean());
        }
        if (argEntity.alterEntries.get(0).isAnimated()) {
            RenderingRegistry.registerEntityRenderingHandler(argEntity.entityClass, (Render)argEntity.renderer);
        }
        animatedEntities.put(argEntity.name, argEntity);
    }

    public Animation getAnimation(String name) {
        return (Animation)this.animations.get(name);
    }

    public static AnimatedEntity get(String name) {
        return animatedEntities.get(name);
    }

    public static AnimatedEntity getByEntity(Entity argEntity) {
        for (String key : animatedEntities.keySet()) {
            if (!AnimatedEntity.animatedEntities.get((Object)key).entityClass.isInstance(argEntity)) continue;
            return animatedEntities.get(key);
        }
        return null;
    }

    public static RenderBendsPlayer getPlayerRenderer(AbstractClientPlayer player) {
        String s = player.func_175154_l();
        RenderBendsPlayer renderplayer = (RenderBendsPlayer)((Object)skinMap.get(s));
        return renderplayer != null ? renderplayer : playerRenderer;
    }
}

