/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.api.rs_ctr.port;

import cd4017be.api.rs_ctr.port.MountedPort;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public interface IConnector
extends INBTSerializable<NBTTagCompound> {
    public static final HashMap<String, Supplier<? extends IConnector>> REGISTRY = new HashMap();

    default public String displayInfo(MountedPort port, int linkID) {
        return linkID != 0 ? "\nID " + linkID : "";
    }

    public void onRemoved(MountedPort var1, @Nullable EntityPlayer var2);

    default public void setPort(MountedPort port) {
    }

    default public void onLoad(MountedPort port) {
        this.setPort(port);
    }

    default public void onUnload() {
    }

    default public void onPortMove(MountedPort port) {
    }

    public static IConnector load(NBTTagCompound nbt) {
        Supplier<? extends IConnector> c = REGISTRY.get(nbt.func_74779_i("id"));
        if (c == null) {
            return null;
        }
        IConnector con = c.get();
        con.deserializeNBT((NBTBase)nbt);
        return con;
    }

    public static interface IConnectorItem {
        public void doAttach(ItemStack var1, MountedPort var2, EntityPlayer var3);
    }
}

