/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.items;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.api.GeolosysAPI;
import com.oitsjustjose.geolosys.common.config.ModConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemProPick
extends Item {
    private HashMap<Integer, Integer> dimensionSeaLevels;

    public ItemProPick() {
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.setRegistryName(new ResourceLocation("geolosys", "PRO_PICK"));
        this.func_77655_b(Objects.requireNonNull(this.getRegistryName()).toString().replaceAll(":", "."));
        MinecraftForge.EVENT_BUS.register((Object)this);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
        this.registerModel();
    }

    private void registerModel() {
        Geolosys.getInstance().clientRegistry.register(new ItemStack((Item)this), new ResourceLocation(Objects.requireNonNull(this.getRegistryName()).toString()), "inventory");
    }

    public void setDimensionSeaLevels(HashMap<Integer, Integer> dimensionSeaLevels) {
        this.dimensionSeaLevels = dimensionSeaLevels;
    }

    public String func_77667_c(@Nonnull ItemStack stack) {
        return Objects.requireNonNull(stack.func_77973_b().getRegistryName()).toString().replaceAll(":", ".");
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (ModConfig.prospecting.enableProPickDamage) {
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74768_a("damage", ModConfig.prospecting.proPickDurability);
            }
            return 1.0 - (double)stack.func_77978_p().func_74762_e("damage") / (double)ModConfig.prospecting.proPickDurability;
        }
        return 1.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (ModConfig.prospecting.enableProPickDamage && Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("damage")) {
                tooltip.add("Durability: " + ModConfig.prospecting.proPickDurability);
            } else {
                tooltip.add("Durability: " + stack.func_77978_p().func_74762_e("damage") + "/" + ModConfig.prospecting.proPickDurability);
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ModConfig.prospecting.enableProPickDamage && stack.func_77942_o();
    }

    public void attemptDamageItem(EntityPlayer player, BlockPos pos, EnumHand hand, World worldIn) {
        if (ModConfig.prospecting.enableProPickDamage && !player.field_71075_bZ.field_75098_d && player.func_184586_b(hand).func_77973_b() instanceof ItemProPick) {
            if (player.func_184586_b(hand).func_77978_p() == null) {
                player.func_184586_b(hand).func_77982_d(new NBTTagCompound());
                player.func_184586_b(hand).func_77978_p().func_74768_a("damage", ModConfig.prospecting.proPickDurability);
            }
            int prevDmg = player.func_184586_b(hand).func_77978_p().func_74762_e("damage");
            player.func_184586_b(hand).func_77978_p().func_74768_a("damage", prevDmg - 1);
            if (player.func_184586_b(hand).func_77978_p().func_74762_e("damage") <= 0) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
                worldIn.func_184133_a(player, pos, new SoundEvent(new ResourceLocation("entity.item.break")), SoundCategory.PLAYERS, 1.0f, 0.85f);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            TextFormatting color;
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74757_a("stone", true);
            } else {
                stack.func_77978_p().func_74757_a("stone", !stack.func_77978_p().func_74767_n("stone"));
            }
            boolean searchForStone = stack.func_77978_p().func_74767_n("stone");
            TextFormatting textFormatting = color = searchForStone ? TextFormatting.AQUA : TextFormatting.GOLD;
            if (searchForStone) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("geolosys.pro_pick.tooltip.mode.stones", new Object[0]), true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("geolosys.pro_pick.tooltip.mode.ores", new Object[0]), true);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            this.func_77659_a(worldIn, player, hand);
        } else {
            int seaLvl;
            this.attemptDamageItem(player, pos, hand, worldIn);
            if (worldIn.field_72995_K) {
                player.func_184609_a(hand);
                return EnumActionResult.PASS;
            }
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_77978_p() == null) {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74757_a("stone", false);
            }
            boolean searchForStone = stack.func_77978_p().func_74767_n("stone");
            try {
                seaLvl = this.dimensionSeaLevels.get(player.field_71093_bK);
            }
            catch (NullPointerException e) {
                seaLvl = worldIn.func_181545_F();
            }
            if (player.func_180425_c().func_177956_o() >= seaLvl) {
                if (searchForStone) {
                    String oreFound = this.findStoneInChunk(worldIn, pos);
                    if (oreFound != null) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("geolosys.pro_pick.tooltip.found_surface", new Object[]{oreFound}), true);
                    } else {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("geolosys.pro_pick.tooltip.nonefound_stone_surface", new Object[0]), true);
                    }
                } else {
                    String oreFound = this.findOreInChunk(worldIn, pos);
                    if (oreFound != null) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("geolosys.pro_pick.tooltip.found_surface", new Object[]{oreFound}), true);
                    } else {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("geolosys.pro_pick.tooltip.nonefound_surface", new Object[0]), true);
                    }
                }
            } else {
                int confAmt = ModConfig.prospecting.proPickRange;
                int confDmt = ModConfig.prospecting.proPickDiameter;
                boolean found = false;
                switch (facing) {
                    case UP: {
                        int xStart = -(confDmt / 2);
                        int xEnd = confDmt / 2;
                        int yStart = -confAmt;
                        int yEnd = 0;
                        int zStart = -(confDmt / 2);
                        int zEnd = confDmt / 2;
                        found = this.isFound(player, worldIn, pos, facing, xStart, xEnd, yStart, yEnd, zStart, zEnd);
                        break;
                    }
                    case DOWN: {
                        int xStart = -(confDmt / 2);
                        int xEnd = confDmt / 2;
                        int yStart = 0;
                        int yEnd = confAmt;
                        int zStart = -(confDmt / 2);
                        int zEnd = confDmt / 2;
                        found = this.isFound(player, worldIn, pos, facing, xStart, xEnd, yStart, yEnd, zStart, zEnd);
                        break;
                    }
                    case NORTH: {
                        int xStart = -(confDmt / 2);
                        int xEnd = confDmt / 2;
                        int yStart = -(confDmt / 2);
                        int yEnd = confDmt / 2;
                        int zStart = 0;
                        int zEnd = confAmt;
                        found = this.isFound(player, worldIn, pos, facing, xStart, xEnd, yStart, yEnd, zStart, zEnd);
                        break;
                    }
                    case SOUTH: {
                        int xStart = -(confDmt / 2);
                        int xEnd = confDmt / 2;
                        int yStart = -(confDmt / 2);
                        int yEnd = confDmt / 2;
                        int zStart = -confAmt;
                        int zEnd = 0;
                        found = this.isFound(player, worldIn, pos, facing, xStart, xEnd, yStart, yEnd, zStart, zEnd);
                        break;
                    }
                    case EAST: {
                        int xStart = -confAmt;
                        int xEnd = 0;
                        int yStart = -(confDmt / 2);
                        int yEnd = confDmt / 2;
                        int zStart = -(confDmt / 2);
                        int zEnd = confDmt / 2;
                        found = this.isFound(player, worldIn, pos, facing, xStart, xEnd, yStart, yEnd, zStart, zEnd);
                        break;
                    }
                    case WEST: {
                        int xStart = 0;
                        int xEnd = confAmt;
                        int yStart = -(confDmt / 2);
                        int yEnd = confDmt / 2;
                        int zStart = -(confDmt / 2);
                        int zEnd = confDmt / 2;
                        found = this.isFound(player, worldIn, pos, facing, xStart, xEnd, yStart, yEnd, zStart, zEnd);
                    }
                }
                if (!found) {
                    String oreFound = this.findOreInChunk(worldIn, pos);
                    if (oreFound != null) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("geolosys.pro_pick.tooltip.found_surface", new Object[]{oreFound}), true);
                    } else {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("geolosys.pro_pick.tooltip.nonefound_surface", new Object[0]), true);
                    }
                }
            }
            player.func_184609_a(hand);
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean isFound(EntityPlayer player, World worldIn, BlockPos pos, EnumFacing facing, int xStart, int xEnd, int yStart, int yEnd, int zStart, int zEnd) {
        boolean found = false;
        for (int x = xStart; x <= xEnd; ++x) {
            block1: for (int y = yStart; y <= yEnd; ++y) {
                for (int z = zStart; z <= zEnd; ++z) {
                    IBlockState state = worldIn.func_180495_p(pos.func_177982_a(x, y, z));
                    if (!GeolosysAPI.oreBlocks.keySet().contains(state)) continue;
                    this.sendFoundMessage(player, state, facing);
                    found = true;
                    continue block1;
                }
            }
        }
        return found;
    }

    private void sendFoundMessage(EntityPlayer player, IBlockState state, EnumFacing facing) {
        player.func_146105_b((ITextComponent)new TextComponentTranslation("geolosys.pro_pick.tooltip.found", new Object[]{new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)).func_82833_r(), facing.func_176734_d()}), true);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onDrawScreen(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || Minecraft.func_71410_x().field_184132_p.func_190074_a() || Minecraft.func_71410_x().field_71474_y.field_74330_P || Minecraft.func_71410_x().field_71474_y.field_74329_Q) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g.func_184614_ca().func_77973_b() instanceof ItemProPick || mc.field_71439_g.func_184592_cb().func_77973_b() instanceof ItemProPick) {
            int seaLvl;
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179140_f();
            try {
                seaLvl = this.dimensionSeaLevels.get(mc.field_71439_g.field_71093_bK);
            }
            catch (NullPointerException e) {
                seaLvl = mc.field_71439_g.func_130014_f_().func_181545_F();
            }
            int level = (int)((double)seaLvl - mc.field_71439_g.field_70163_u);
            if (level < 0) {
                mc.field_71466_p.func_175063_a("Depth: " + Math.abs(level) + "m above sea-level", (float)ModConfig.client.hudX, (float)ModConfig.client.hudY, -1);
            } else if (level == 0) {
                mc.field_71466_p.func_175063_a("Depth: at sea-level", (float)ModConfig.client.hudX, (float)ModConfig.client.hudY, -1);
            } else {
                mc.field_71466_p.func_175063_a("Depth: " + level + "m below sea-level", (float)ModConfig.client.hudX, (float)ModConfig.client.hudY, -1);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private String findOreInChunk(World world, BlockPos pos) {
        ChunkPos tempPos = new ChunkPos(pos);
        ModConfig.Prospecting.SURFACE_PROSPECTING_TYPE searchType = ModConfig.prospecting.surfaceProspectingResults;
        if (searchType == ModConfig.Prospecting.SURFACE_PROSPECTING_TYPE.OREBLOCKS) {
            for (int x = tempPos.func_180334_c(); x <= tempPos.func_180332_e(); ++x) {
                for (int z = tempPos.func_180333_d(); z <= tempPos.func_180330_f(); ++z) {
                    for (int y = 0; y < world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o(); ++y) {
                        if (!GeolosysAPI.oreBlocks.keySet().contains(world.func_180495_p(new BlockPos(x, y, z)))) continue;
                        return this.getNameForBlockState(world.func_180495_p(new BlockPos(x, y, z)));
                    }
                }
            }
        } else {
            for (int x = tempPos.func_180334_c(); x <= tempPos.func_180332_e(); ++x) {
                for (int z = tempPos.func_180333_d(); z <= tempPos.func_180330_f(); ++z) {
                    for (int y = 0; y < world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o(); ++y) {
                        for (Map.Entry<IBlockState, IBlockState> e : GeolosysAPI.oreBlocks.entrySet()) {
                            if (e.getValue() != world.func_180495_p(new BlockPos(x, y, z))) continue;
                            return this.getNameForBlockState(e.getKey());
                        }
                    }
                }
            }
        }
        return null;
    }

    private String findStoneInChunk(World world, BlockPos pos) {
        ChunkPos tempPos = new ChunkPos(pos);
        for (int x = tempPos.func_180334_c(); x <= tempPos.func_180332_e(); ++x) {
            for (int z = tempPos.func_180333_d(); z <= tempPos.func_180330_f(); ++z) {
                for (int y = 0; y < world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o(); ++y) {
                    if (!GeolosysAPI.stones.contains(world.func_180495_p(new BlockPos(x, y, z)))) continue;
                    return this.getNameForBlockState(world.func_180495_p(new BlockPos(x, y, z)));
                }
            }
        }
        return null;
    }

    private String getNameForBlockState(IBlockState state) {
        return new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)).func_82833_r();
    }
}

