/*
 * Decompiled with CFR 0.152.
 */
package com.karjah.betterbedrock;

import com.karjah.betterbedrock.util.LogHelper;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class Config {
    private static final String CATEGORY_DIMENSIONS = "dimensions";
    private static final String CATEGORY_RETROGEN = "Retrogen";
    public static Configuration config;
    public static int[] DIMENSIONS;
    public static boolean RETRO_ENABLED;
    public static boolean RETRO_REBUILD;
    public static int RETRO_VERSION;

    public static void readConfig(File configFile) {
        config = new Configuration(new File(configFile.getPath(), "BetterBedrock.cfg"));
        try {
            config.load();
            Config.initDimensionConfig(config);
            Config.initRetrogenConfig(config);
        }
        catch (Exception ex) {
            LogHelper.error("Failed to load config file: " + ex.getMessage());
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    private static void initDimensionConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_DIMENSIONS, "Dimension Configuration");
        DIMENSIONS = cfg.get(CATEGORY_DIMENSIONS, "whitelist", new int[]{0, -1}, "Dimentions to generate flat bedrock in").getIntList();
    }

    private static void initRetrogenConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_RETROGEN, "Retro-Generation Config");
        RETRO_ENABLED = cfg.getBoolean("enabled", CATEGORY_RETROGEN, false, "Enabled chunks to be regenerated. This will probability cause lag until chunks are done.");
        RETRO_REBUILD = cfg.getBoolean("rebuild", CATEGORY_RETROGEN, false, "Enable this only to rebuild the Bedrock at y level 0. Retrogen must be enabled to work.");
        RETRO_VERSION = cfg.getInt("marker", CATEGORY_RETROGEN, 1, 1, Integer.MAX_VALUE, "Marker for marking chunks that have been generated. Must be a number.");
    }
}

