/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.crafttweaker;

import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.crafting.endercrafter.EnderCrafterRecipeManager;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeShaped;
import com.blakebr0.extendedcrafting.crafting.table.TableRecipeShapeless;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.CraftingHelper;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.extendedcrafting.EnderCrafting")
public class EnderCrafting {
    @ZenMethod
    public static void addShaped(IItemStack output, IIngredient[][] ingredients) {
        EnderCrafting.addShaped(output, ingredients, ModConfig.confEnderTimeRequired);
    }

    @ZenMethod
    public static void addShaped(IItemStack output, IIngredient[][] ingredients, int seconds) {
        int height = ingredients.length;
        int width = 0;
        for (IIngredient[] row : ingredients) {
            if (width >= row.length) continue;
            width = row.length;
        }
        NonNullList input = NonNullList.func_191197_a((int)(height * width), (Object)Ingredient.field_193370_a);
        int i = 0;
        for (int a = 0; a < height; ++a) {
            for (int b = 0; b < ingredients[a].length; ++b) {
                Ingredient ing = CraftingHelper.getIngredient((Object)EnderCrafting.toObject(ingredients[a][b]));
                if (ing == null) {
                    ing = Ingredient.field_193370_a;
                }
                i = a * width + b;
                input.set(i, (Object)ing);
            }
        }
        TableRecipeShaped recipe = new TableRecipeShaped(1, EnderCrafting.toStack(output), width, height, (NonNullList<Ingredient>)input);
        recipe.enderCrafterRecipeTimeRequired = seconds;
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IIngredient[] ingredients) {
        EnderCrafting.addShapeless(output, ingredients, ModConfig.confEnderTimeRequired);
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IIngredient[] ingredients, int seconds) {
        TableRecipeShapeless recipe = new TableRecipeShapeless(1, EnderCrafting.toStack(output), EnderCrafting.toObjects(ingredients));
        recipe.enderCrafterRecipeTimeRequired = seconds;
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void remove(IItemStack target) {
        CraftTweakerAPI.apply((IAction)new Remove(EnderCrafting.toStack(target)));
    }

    private static ItemStack toStack(IItemStack item) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        Object internal = item.getInternal();
        if (internal == null || !(internal instanceof ItemStack)) {
            CraftTweakerAPI.getLogger().logError("Not a valid item stack: " + item);
        }
        return (ItemStack)internal;
    }

    private static Object toObject(IIngredient ingredient) {
        if (ingredient == null) {
            return null;
        }
        if (ingredient instanceof IOreDictEntry) {
            return EnderCrafting.toString((IOreDictEntry)ingredient);
        }
        if (ingredient instanceof IItemStack) {
            return EnderCrafting.toStack((IItemStack)ingredient);
        }
        return null;
    }

    private static Object[] toObjects(IIngredient[] list) {
        if (list == null) {
            return null;
        }
        Object[] ingredients = new Object[list.length];
        for (int x = 0; x < list.length; ++x) {
            ingredients[x] = EnderCrafting.toObject(list[x]);
        }
        return ingredients;
    }

    private static List toList(IIngredient[] list) {
        return Arrays.asList(EnderCrafting.toObjects(list));
    }

    private static String toString(IOreDictEntry entry) {
        return entry.getName();
    }

    private static class Remove
    implements IAction {
        ItemStack remove;

        public Remove(ItemStack remove) {
            this.remove = remove;
        }

        public void apply() {
            EnderCrafterRecipeManager.getInstance().removeRecipes(this.remove);
        }

        public String describe() {
            return "Removing all Ender Crafting recipes for " + this.remove.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        IRecipe recipe;

        public Add(IRecipe add) {
            this.recipe = add;
        }

        public void apply() {
            EnderCrafterRecipeManager.getInstance().getRecipes().add(this.recipe);
        }

        public String describe() {
            return "Adding an Ender Crafting recipe for " + this.recipe.func_77571_b().func_82833_r();
        }
    }
}

