/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import io.netty.buffer.ByteBuf;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.network.BaseSettingsMessage;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class OpenGuiMessage
extends BaseSettingsMessage {
    private What what;
    private int filterSlotIndex;

    public OpenGuiMessage() {
    }

    private OpenGuiMessage(What what, BlockPos pos, EnumHand hand, int moduleSlotIndex, int filterSlotIndex) {
        super(pos, hand, moduleSlotIndex, null);
        this.what = what;
        this.filterSlotIndex = filterSlotIndex;
    }

    public static OpenGuiMessage openRouter(BlockPos pos) {
        return new OpenGuiMessage(What.ROUTER, pos, null, -1, -1);
    }

    public static OpenGuiMessage openModuleInHand(EnumHand hand) {
        return new OpenGuiMessage(What.MODULE_HELD, null, hand, -1, -1);
    }

    public static OpenGuiMessage openModuleInRouter(BlockPos routerPos, Integer moduleSlotIndex) {
        return new OpenGuiMessage(What.MODULE_INSTALLED, routerPos, null, moduleSlotIndex, -1);
    }

    public static OpenGuiMessage openFilterInModule(EnumHand hand, int filterSlotIndex) {
        return new OpenGuiMessage(What.FILTER_HELD, null, hand, -1, filterSlotIndex);
    }

    public static OpenGuiMessage openFilterInInstalledModule(BlockPos routerPos, int moduleSlotIndex, int filterSlotIndex) {
        return new OpenGuiMessage(What.FILTER_INSTALLED, routerPos, null, moduleSlotIndex, filterSlotIndex);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.what = What.values()[buf.readByte()];
        switch (this.what) {
            case ROUTER: {
                this.routerPos = this.readPos(buf);
                break;
            }
            case MODULE_HELD: {
                this.hand = EnumHand.values()[buf.readByte()];
                break;
            }
            case MODULE_INSTALLED: {
                this.routerPos = this.readPos(buf);
                this.moduleSlotIndex = buf.readByte();
                break;
            }
            case FILTER_HELD: {
                this.hand = EnumHand.values()[buf.readByte()];
                this.filterSlotIndex = buf.readByte();
                break;
            }
            case FILTER_INSTALLED: {
                this.routerPos = this.readPos(buf);
                this.moduleSlotIndex = buf.readByte();
                this.filterSlotIndex = buf.readByte();
            }
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.what.ordinal());
        switch (this.what) {
            case ROUTER: {
                this.writePos(buf, this.routerPos);
                break;
            }
            case MODULE_HELD: {
                buf.writeByte(this.hand.ordinal());
                break;
            }
            case MODULE_INSTALLED: {
                this.writePos(buf, this.routerPos);
                buf.writeByte(this.moduleSlotIndex);
                break;
            }
            case FILTER_HELD: {
                buf.writeByte(this.hand.ordinal());
                buf.writeByte(this.filterSlotIndex);
                break;
            }
            case FILTER_INSTALLED: {
                this.writePos(buf, this.routerPos);
                buf.writeByte(this.moduleSlotIndex);
                buf.writeByte(this.filterSlotIndex);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<OpenGuiMessage, IMessage> {
        public IMessage onMessage(OpenGuiMessage message, MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.func_130014_f_();
            mainThread.func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                BlockPos pos = player.func_180425_c();
                TileEntityItemRouter router = null;
                if (message.routerPos != null) {
                    pos = message.routerPos;
                    router = TileEntityItemRouter.getRouterAt((IBlockAccess)player.func_130014_f_(), pos);
                }
                switch (message.what) {
                    case ROUTER: {
                        if (router == null) break;
                        player.openGui((Object)ModularRouters.instance, ModularRouters.GUI_ROUTER, player.func_130014_f_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        break;
                    }
                    case MODULE_HELD: {
                        player.openGui((Object)ModularRouters.instance, message.hand == EnumHand.MAIN_HAND ? ModularRouters.GUI_MODULE_HELD_MAIN : ModularRouters.GUI_MODULE_HELD_OFF, player.func_130014_f_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        break;
                    }
                    case MODULE_INSTALLED: {
                        if (router == null) break;
                        router.playerConfiguringModule((EntityPlayer)player, message.moduleSlotIndex);
                        player.openGui((Object)ModularRouters.instance, ModularRouters.GUI_MODULE_INSTALLED, player.func_130014_f_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        break;
                    }
                    case FILTER_HELD: {
                        ModuleHelper.setFilterConfigSlot(player.func_184586_b(message.hand), message.filterSlotIndex);
                        player.openGui((Object)ModularRouters.instance, message.hand == EnumHand.MAIN_HAND ? ModularRouters.GUI_FILTER_HELD_MAIN : ModularRouters.GUI_FILTER_HELD_OFF, player.func_130014_f_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        break;
                    }
                    case FILTER_INSTALLED: {
                        if (router == null) break;
                        router.playerConfiguringModule((EntityPlayer)player, message.moduleSlotIndex, message.filterSlotIndex);
                        player.openGui((Object)ModularRouters.instance, ModularRouters.GUI_FILTER_INSTALLED, player.func_130014_f_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    }
                }
            });
            return null;
        }
    }

    private static enum What {
        ROUTER,
        MODULE_HELD,
        MODULE_INSTALLED,
        FILTER_HELD,
        FILTER_INSTALLED;

    }
}

