/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic;

import java.util.Objects;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ModuleTarget {
    public final int dimId;
    public final BlockPos pos;
    public final EnumFacing face;
    public final String invName;

    public ModuleTarget(int dimId, BlockPos pos, EnumFacing face, String invName) {
        this.dimId = dimId;
        this.pos = pos;
        this.face = face;
        this.invName = invName;
    }

    public ModuleTarget(int dimId, BlockPos pos, EnumFacing face) {
        this(dimId, pos, face, "");
    }

    public ModuleTarget(int dimId, BlockPos pos) {
        this(dimId, pos, null);
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound ext = new NBTTagCompound();
        ext.func_74768_a("Dimension", this.dimId);
        ext.func_74768_a("X", this.pos.func_177958_n());
        ext.func_74768_a("Y", this.pos.func_177956_o());
        ext.func_74768_a("Z", this.pos.func_177952_p());
        ext.func_74774_a("Face", (byte)this.face.ordinal());
        ext.func_74778_a("InvName", this.invName);
        return ext;
    }

    public static ModuleTarget fromNBT(NBTTagCompound nbt) {
        BlockPos pos = new BlockPos(nbt.func_74762_e("X"), nbt.func_74762_e("Y"), nbt.func_74762_e("Z"));
        EnumFacing face = EnumFacing.values()[nbt.func_74771_c("Face")];
        return new ModuleTarget(nbt.func_74762_e("Dimension"), pos, face, nbt.func_74779_i("InvName"));
    }

    public IItemHandler getItemHandler() {
        WorldServer w = DimensionManager.getWorld((int)this.dimId);
        if (w == null || !w.func_72863_F().func_73149_a(this.pos.func_177958_n() >> 4, this.pos.func_177952_p() >> 4)) {
            return null;
        }
        TileEntity te = w.func_175625_s(this.pos);
        if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.face)) {
            return null;
        }
        return (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.face);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleTarget)) {
            return false;
        }
        ModuleTarget that = (ModuleTarget)o;
        return this.dimId == that.dimId && Objects.equals(this.pos, that.pos) && this.face == that.face;
    }

    public int hashCode() {
        return Objects.hash(this.dimId, this.pos, this.face);
    }

    public String toString() {
        String s = this.invName == null || this.invName.isEmpty() ? "" : " [" + this.invName + "]";
        return MiscUtil.locToString(this.dimId, this.pos) + " " + this.face + s;
    }
}

