/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.upgrade;

import java.util.List;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.core.RegistrarMR;
import me.desht.modularrouters.item.upgrade.ItemUpgrade;
import me.desht.modularrouters.item.upgrade.Upgrade;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class CamouflageUpgrade
extends Upgrade {
    private static final String NBT_STATE_NAME = "BlockStateName";
    private static final String NBT_STATE_META = "BlockStateMeta";

    @Override
    public void addExtraInformation(ItemStack itemstack, World player, List<String> list, ITooltipFlag advanced) {
        if (itemstack.func_77942_o() && itemstack.func_77978_p().func_74764_b(NBT_STATE_NAME)) {
            list.add(I18n.func_135052_a((String)"itemText.camouflage.held", (Object[])new Object[]{CamouflageUpgrade.getCamoStateDisplayName(itemstack)}));
        }
    }

    @Override
    public void onCompiled(ItemStack stack, TileEntityItemRouter router) {
        super.onCompiled(stack, router);
        router.setCamouflage(CamouflageUpgrade.getCamoState(stack));
    }

    private static void setCamoState(ItemStack stack, IBlockState camoState) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound compound = stack.func_77978_p();
        CamouflageUpgrade.writeToNBT(compound, camoState);
    }

    public static void writeToNBT(NBTTagCompound compound, IBlockState camoState) {
        Block b = camoState.func_177230_c();
        compound.func_74778_a(NBT_STATE_NAME, b.getRegistryName().toString());
        compound.func_74768_a(NBT_STATE_META, b.func_176201_c(camoState));
    }

    public static IBlockState readFromNBT(NBTTagCompound compound) {
        if (!compound.func_74764_b(NBT_STATE_NAME)) {
            return null;
        }
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(compound.func_74779_i(NBT_STATE_NAME)));
        return b != null ? b.func_176203_a(compound.func_74762_e(NBT_STATE_META)) : null;
    }

    private static IBlockState getCamoState(ItemStack stack) {
        return stack.func_77942_o() ? CamouflageUpgrade.readFromNBT(stack.func_77978_p()) : null;
    }

    private static String getCamoStateDisplayName(ItemStack stack) {
        Block b;
        Item item;
        IBlockState state = CamouflageUpgrade.getCamoState(stack);
        if (state != null && (item = Item.func_150898_a((Block)(b = state.func_177230_c()))) != null) {
            return new ItemStack(item, 1, b.func_176201_c(state)).func_82833_r();
        }
        return "<?>";
    }

    @Mod.EventBusSubscriber
    public static class Interacted {
        @SubscribeEvent
        public static void onInteracted(PlayerInteractEvent.RightClickBlock event) {
            EntityPlayer player = event.getEntityPlayer();
            ItemStack stack = player.func_184586_b(event.getHand());
            if (ItemUpgrade.isType(stack, ItemUpgrade.UpgradeType.CAMOUFLAGE) && player.func_70093_af()) {
                IBlockState state = event.getWorld().func_180495_p(event.getPos());
                if (Interacted.isBlockOKForCamo(state)) {
                    CamouflageUpgrade.setCamoState(stack, state);
                    if (!event.getWorld().field_72995_K) {
                        event.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("itemText.camouflage.held", new Object[]{CamouflageUpgrade.getCamoStateDisplayName(stack)}), false);
                        event.setCanceled(true);
                    } else {
                        event.getEntityPlayer().func_184185_a(RegistrarMR.SOUND_SUCCESS, 1.0f, 1.5f);
                    }
                } else if (event.getWorld().field_72995_K) {
                    event.getEntityPlayer().func_184185_a(RegistrarMR.SOUND_ERROR, 1.0f, 1.0f);
                }
            }
        }

        private static boolean isBlockOKForCamo(IBlockState state) {
            return state.func_185901_i() == EnumBlockRenderType.MODEL && state.func_177230_c() != RegistrarMR.ITEM_ROUTER;
        }
    }
}

