/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters;

import java.util.Random;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.block.tile.TileEntityTemplateFrame;
import me.desht.modularrouters.client.gui.GuiHandler;
import me.desht.modularrouters.integration.IntegrationHandler;
import me.desht.modularrouters.integration.XPCollection;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.GuiSyncMessage;
import me.desht.modularrouters.network.ModuleSettingsMessage;
import me.desht.modularrouters.network.OpenGuiMessage;
import me.desht.modularrouters.network.ParticleBeamMessage;
import me.desht.modularrouters.network.PlaySoundMessage;
import me.desht.modularrouters.network.PushEntityMessage;
import me.desht.modularrouters.network.RouterSettingsMessage;
import me.desht.modularrouters.network.SyncUpgradeSettingsMessage;
import me.desht.modularrouters.proxy.IProxy;
import me.desht.modularrouters.recipe.ModRecipes;
import me.desht.modularrouters.util.MiscUtil;
import me.desht.modularrouters.util.ModNameCache;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="modularrouters", version="1.12.2-3.3.0-33", name="Modular Routers", dependencies="after:waila;before:guideapi@[1.12-2.1.4-56,);after:theoneprobe;required-after:forge@[14.23.4.2705,);", acceptedMinecraftVersions="1.12", updateJSON="https://raw.github.com/desht/ModularRouters/MC1.12-master/release_info.json")
public class ModularRouters {
    public static final String MODID = "modularrouters";
    public static final String MODNAME = "Modular Routers";
    static final String MODVERSION = "1.12.2-3.3.0-33";
    static final String DEPENDENICES = "after:waila;before:guideapi@[1.12-2.1.4-56,);after:theoneprobe;required-after:forge@[14.23.4.2705,);";
    public static Logger logger;
    public static SimpleNetworkWrapper network;
    public static Random random;
    private static int modGuiIndex;
    public static final int GUI_MODULE_HELD_MAIN;
    public static final int GUI_MODULE_HELD_OFF;
    public static final int GUI_ROUTER;
    public static final int GUI_MODULE_INSTALLED;
    public static final int GUI_FILTER_HELD_MAIN;
    public static final int GUI_FILTER_HELD_OFF;
    public static final int GUI_FILTER_INSTALLED;
    public static final int GUI_SYNC_UPGRADE;
    @SidedProxy(serverSide="me.desht.modularrouters.proxy.ServerProxy", clientSide="me.desht.modularrouters.proxy.ClientProxy")
    public static IProxy proxy;
    @Mod.Instance(value="modularrouters")
    public static ModularRouters instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        proxy.preInit();
        this.setupNetwork();
        GameRegistry.registerTileEntity(TileEntityItemRouter.class, (ResourceLocation)MiscUtil.RL("item_router"));
        GameRegistry.registerTileEntity(TileEntityTemplateFrame.class, (ResourceLocation)MiscUtil.RL("template_frame"));
        logger.info("Modular Routers is loading!");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        ModRecipes.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        IntegrationHandler.registerAll();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        XPCollection.detectXPFluids();
        ModNameCache.init();
    }

    private void setupNetwork() {
        int d = 0;
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        network.registerMessage(RouterSettingsMessage.Handler.class, RouterSettingsMessage.class, d++, Side.SERVER);
        network.registerMessage(ModuleSettingsMessage.Handler.class, ModuleSettingsMessage.class, d++, Side.SERVER);
        network.registerMessage(FilterSettingsMessage.Handler.class, FilterSettingsMessage.class, d++, Side.SERVER);
        network.registerMessage(OpenGuiMessage.Handler.class, OpenGuiMessage.class, d++, Side.SERVER);
        network.registerMessage(ParticleBeamMessage.Handler.class, ParticleBeamMessage.class, d++, Side.CLIENT);
        network.registerMessage(GuiSyncMessage.Handler.class, GuiSyncMessage.class, d++, Side.CLIENT);
        network.registerMessage(SyncUpgradeSettingsMessage.Handler.class, SyncUpgradeSettingsMessage.class, d++, Side.SERVER);
        network.registerMessage(PushEntityMessage.Handler.class, PushEntityMessage.class, d++, Side.CLIENT);
        network.registerMessage(PlaySoundMessage.Handler.class, PlaySoundMessage.class, d++, Side.CLIENT);
    }

    static {
        random = new Random();
        modGuiIndex = 0;
        GUI_MODULE_HELD_MAIN = modGuiIndex++;
        GUI_MODULE_HELD_OFF = modGuiIndex++;
        GUI_ROUTER = modGuiIndex++;
        GUI_MODULE_INSTALLED = modGuiIndex++;
        GUI_FILTER_HELD_MAIN = modGuiIndex++;
        GUI_FILTER_HELD_OFF = modGuiIndex++;
        GUI_FILTER_INSTALLED = modGuiIndex++;
        GUI_SYNC_UPGRADE = modGuiIndex++;
    }
}

