/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.util;

import cd4017be.lib.util.Callback;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class VariableInventory
implements IItemHandlerModifiable {
    public ItemStack[] items;
    public int slots;
    public int stackSize;
    private final Callback onModified;
    public boolean locked;

    public VariableInventory(int maxSlots, Callback modificationCallback) {
        this.onModified = modificationCallback;
        this.items = new ItemStack[maxSlots];
        Arrays.fill(this.items, ItemStack.field_190927_a);
        this.slots = maxSlots;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.items[slot] = stack;
        this.onModified.call();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.items[slot];
    }

    public int getSlots() {
        return this.slots;
    }

    public int getSlotLimit(int slot) {
        return this.stackSize;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack item = this.items[slot];
        int n = item.func_190916_E();
        int m = stack.func_190916_E();
        if (m <= 0 || n != 0 && !ItemHandlerHelper.canItemStacksStack((ItemStack)item, (ItemStack)stack)) {
            return stack;
        }
        if (n == Integer.MAX_VALUE) {
            n = 0;
        }
        if (m > this.stackSize - n && (m = this.stackSize - n) <= 0) {
            return stack;
        }
        if (!simulate) {
            if (n == 0) {
                this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)m));
            } else {
                item.func_190917_f(m);
                this.setStackInSlot(slot, item);
            }
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - m));
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack item = this.items[slot];
        int n = item.func_190916_E();
        if (n == Integer.MAX_VALUE) {
            if (!this.locked) {
                this.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            return ItemStack.field_190927_a;
        }
        if (n < amount) {
            amount = n;
        }
        if (amount <= 0) {
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            if (amount < n) {
                item.func_190918_g(amount);
                this.setStackInSlot(slot, item);
            } else if (this.locked) {
                item.func_190920_e(Integer.MAX_VALUE);
                this.setStackInSlot(slot, item);
            } else {
                this.setStackInSlot(slot, ItemStack.field_190927_a);
            }
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)item, (int)amount);
    }

    public int getComparatorValue() {
        if (this.slots == 0) {
            return 7;
        }
        long count = 0L;
        for (int i = 0; i < this.slots; ++i) {
            int n = this.items[i].func_190916_E();
            if (n == Integer.MAX_VALUE) continue;
            count += (long)n;
        }
        return (int)(count * 14L / (long)this.stackSize / (long)this.slots) + (count > 0L ? 1 : 0);
    }

    public class GroupAccess
    implements IItemHandler {
        public int start = 0;
        public int size;

        public GroupAccess() {
            this.size = VariableInventory.this.slots;
        }

        public void setRange(int start, int end) {
            if (end > VariableInventory.this.items.length) {
                end = VariableInventory.this.items.length;
            }
            if (start < 0) {
                start = 0;
            }
            this.start = start;
            this.size = end < start ? 0 : end - start;
        }

        public int getSlots() {
            return this.size;
        }

        public ItemStack getStackInSlot(int slot) {
            return VariableInventory.this.items[slot + this.start];
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return VariableInventory.this.insertItem(slot + this.start, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return VariableInventory.this.extractItem(slot + this.start, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return VariableInventory.this.stackSize;
        }
    }
}

