/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.tileentity;

import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.GlitchSaveSlot;
import cd4017be.lib.Gui.ITankContainer;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.capability.AbstractInventory;
import cd4017be.lib.capability.AdvancedTank;
import cd4017be.lib.tileentity.BaseTileEntity;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class Tank
extends BaseTileEntity
implements AdvancedBlock.INeighborAwareTile,
AdvancedBlock.ITilePlaceHarvest,
ITickable,
DataContainer.IGuiData,
BlockGuiHandler.ClientPacketReceiver,
AdvancedBlock.IComparatorSource {
    public static final int[] CAP = new int[]{8000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public AdvancedTank tank = new AdvancedTank((TileEntity)this, CAP[0], false);
    private IItemHandler inventory = new Inventory();
    private TileEntity target;
    private byte type;
    public boolean auto;
    public boolean checkTarget = true;
    private int lastAmount;
    private int comparator;

    public Tank() {
    }

    public Tank(IBlockState state) {
        super(state);
        this.type = (byte)state.func_177230_c().func_176201_c(state);
        this.tank.cap = CAP[this.type];
    }

    public void func_73660_a() {
        int n;
        IFluidHandler acc;
        if (this.field_145850_b.field_72995_K || (this.field_145850_b.func_82737_E() & 7L) != 0L) {
            return;
        }
        if (this.checkTarget || this.target != null && this.target.func_145837_r()) {
            this.checkTarget = false;
            this.target = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
            if (this.target != null && !this.target.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)) {
                this.target = null;
            }
        }
        if (this.target != null && this.tank.amount() > 0 && (acc = (IFluidHandler)this.target.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)) != null) {
            this.tank.decrement(acc.fill(this.tank.fluid, true));
        }
        if ((n = this.lastAmount - this.tank.amount()) != 0 && (this.lastAmount == 0 || this.tank.fluid == null || Math.abs(n) > this.tank.cap / 64)) {
            this.lastAmount -= n;
            this.markUpdate();
        }
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        return cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(this.auto ? this.inventory : this.tank);
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.type = (byte)(nbt.func_74771_c("type") & 0xF);
        this.tank.cap = CAP[this.type];
        this.tank.output = nbt.func_74767_n("fill");
        this.tank.readNBT(nbt.func_74775_l("tank"));
        this.auto = nbt.func_74767_n("auto");
        if (nbt.func_150297_b("fluid", 10)) {
            this.tank.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("fluid"));
        }
        if (nbt.func_150297_b("item", 10)) {
            this.tank.setStackInSlot(0, new ItemStack(nbt.func_74775_l("item")));
        }
        this.tank.lock |= nbt.func_74767_n("lock");
        this.lastAmount = this.tank.amount();
        this.checkTarget = true;
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeNBT(new NBTTagCompound()));
        nbt.func_74757_a("fill", this.tank.output);
        nbt.func_74757_a("auto", this.auto);
        nbt.func_74774_a("type", this.type);
        return super.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.tank.fluid != null) {
            this.tank.fluid.writeToNBT(nbt);
        }
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.tank.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)pkt.func_148857_g());
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        if (item.func_77942_o()) {
            this.tank.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)item.func_77978_p());
            this.lastAmount = this.tank.amount();
        }
        this.tank.lock = this.tank.fluid != null && this.tank.fluid.amount == 0;
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        List list = this.makeDefaultDrops(this.tank.fluid == null ? null : this.tank.fluid.writeToNBT(new NBTTagCompound()));
        this.tank.addToList(list);
        return list;
    }

    public void neighborBlockChange(Block b, BlockPos src) {
        if (src.equals((Object)this.field_174879_c.func_177977_b())) {
            this.checkTarget = true;
        }
    }

    public void neighborTileChange(TileEntity te, EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            this.target = te;
            this.checkTarget = false;
        }
    }

    public void initContainer(DataContainer container) {
        TileContainer cont = (TileContainer)container;
        cont.addTankSlot(new TileContainer.TankSlot((ITankContainer)this.tank, 0, 184, 16, 35));
        cont.addItemSlot((Slot)new GlitchSaveSlot((IItemHandler)this.tank, 0, 184, 74));
        cont.addPlayerInventory(8, 16);
    }

    public int[] getSyncVariables() {
        return new int[]{(this.tank.lock ? 1 : 0) | (this.tank.output ? 2 : 0) | (this.auto ? 4 : 0)};
    }

    public void setSyncVariable(int i, int v) {
        this.tank.lock = (v & 1) != 0;
        this.tank.output = (v & 2) != 0;
        this.auto = (v & 4) != 0;
    }

    public boolean detectAndSendChanges(DataContainer container, PacketBuffer dos) {
        return false;
    }

    public void updateClientChanges(DataContainer container, PacketBuffer dis) {
    }

    public void onPacketFromClient(PacketBuffer data, EntityPlayer sender) throws IOException {
        switch (data.readByte()) {
            case 0: {
                if (this.tank.fluid == null) break;
                this.tank.decrement(this.tank.fluid.amount);
                break;
            }
            case 1: {
                this.tank.setLock(!this.tank.lock);
                break;
            }
            case 2: {
                this.tank.setOut(!this.tank.output);
                break;
            }
            case 3: {
                this.auto = !this.auto;
            }
        }
        this.func_70296_d();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70296_d() {
        if (!this.field_145850_b.field_72995_K && this.comparator >= 0) {
            this.comparator = -1;
            TickRegistry.instance.updates.add(() -> this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h));
        }
        super.func_70296_d();
    }

    public int comparatorValue() {
        return this.comparator < 0 ? (this.comparator = this.tank.getComparatorValue()) : this.comparator;
    }

    private class Inventory
    extends AbstractInventory {
        private Inventory() {
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            Tank.this.tank.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return Tank.this.tank.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return Tank.this.tank.getStackInSlot(slot);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (Tank.this.tank.transposing()) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }
}

