/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.tileentity;

import cd4017be.api.indlog.filter.ItemFilterProvider;
import cd4017be.api.indlog.pipe.IItemPipeCon;
import cd4017be.indlog.filter.DummyFilter;
import cd4017be.indlog.tileentity.Pipe;
import cd4017be.lib.capability.AbstractInventory;
import cd4017be.lib.capability.LinkedInventory;
import cd4017be.lib.util.ItemFluidUtil;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemPipe
extends Pipe<ItemPipe, ItemStack, IItemHandler> {
    public static int TICKS;
    protected final IItemHandler access = new LinkedInventory(1, 64, this::getItem, this::setItem);
    protected final IItemHandler accessF = new Inventory();

    public ItemPipe() {
    }

    public ItemPipe(IBlockState state) {
        super(state);
    }

    @Override
    protected Class<ItemPipe> pipeClass() {
        return ItemPipe.class;
    }

    @Override
    protected Capability<IItemHandler> capability() {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    protected int resetTimer() {
        return TICKS;
    }

    @Override
    protected IItemHandler getInv(boolean filtered) {
        return filtered ? this.accessF : this.access;
    }

    private ItemStack getItem(int i) {
        return this.content == null ? ItemStack.field_190927_a : (ItemStack)this.content;
    }

    private void setItem(ItemStack item, int i) {
        this.content = item.func_190926_b() ? null : item;
        this.func_70296_d();
    }

    @Override
    protected byte conDir(TileEntity te, EnumFacing side) {
        return te instanceof IItemPipeCon ? ((IItemPipeCon)te).getItemConnectDir(side) : (byte)0;
    }

    @Override
    protected boolean transferOut(IItemHandler acc) {
        if (this.filter == null || this.filter.noEffect()) {
            this.content = ItemHandlerHelper.insertItemStacked((IItemHandler)acc, (ItemStack)((ItemStack)this.content), (boolean)false);
            if (this.content.func_190916_E() > 0) {
                return false;
            }
        } else {
            int m = this.filter.insertAmount(this.content, (Object)acc);
            if (m <= 0) {
                return false;
            }
            ((ItemStack)this.content).func_190917_f(ItemHandlerHelper.insertItemStacked((IItemHandler)acc, (ItemStack)((ItemStack)this.content).func_77979_a(m), (boolean)false).func_190916_E());
            if (((ItemStack)this.content).func_190916_E() > 0) {
                return false;
            }
        }
        this.content = null;
        return true;
    }

    @Override
    protected boolean transferIn(IItemHandler acc) {
        if (this.filter == null || this.filter.noEffect()) {
            if (this.content == null) {
                this.setItem(ItemFluidUtil.drain((IItemHandler)acc, (int)-1), 0);
            } else {
                int m = ((ItemStack)this.content).func_77976_d() - ((ItemStack)this.content).func_190916_E();
                if (m <= 0) {
                    return true;
                }
                ((ItemStack)this.content).func_190917_f(ItemFluidUtil.drain((IItemHandler)acc, (ItemStack)((ItemStack)this.content), (int)m));
                this.func_70296_d();
            }
        } else {
            int n;
            if (this.content == null) {
                n = 0;
            } else {
                n = ((ItemStack)this.content).func_190916_E();
                if (n >= ((ItemStack)this.content).func_77976_d()) {
                    return true;
                }
            }
            ItemStack extr = (ItemStack)this.filter.getExtract((Object)this.getItem(0), (Object)acc);
            if (extr.func_190916_E() <= 0) {
                return false;
            }
            int m = Math.min(extr.func_77976_d() - n, extr.func_190916_E());
            extr.func_190920_e(ItemFluidUtil.drain((IItemHandler)acc, (ItemStack)extr, (int)m) + n);
            this.content = extr;
            this.func_70296_d();
        }
        return false;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing dir, float X, float Y, float Z) {
        if (super.onActivated(player, hand, item, dir, X, Y, Z)) {
            return true;
        }
        if (this.filter != null && !player.func_70093_af() && item.func_190916_E() == 0) {
            player.func_184611_a(hand, this.filter.getItemStack());
            this.filter = null;
            this.flow = (short)(this.flow | 0x8000);
            this.markUpdate();
            this.func_70296_d();
            return true;
        }
        if (this.filter == null && this.type != 0 && item.func_77973_b() instanceof ItemFilterProvider && (this.filter = ((ItemFilterProvider)item.func_77973_b()).getItemFilter(item)) != null) {
            this.flow = (short)(this.flow & Short.MAX_VALUE);
            item.func_190917_f(-1);
            player.func_184611_a(hand, item);
            this.markUpdate();
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.filter != null) {
            nbt.func_74782_a("filter", (NBTBase)this.filter.writeNBT());
        }
        if (this.content != null) {
            nbt.func_74782_a("item", (NBTBase)((ItemStack)this.content).func_77955_b(new NBTTagCompound()));
        }
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.filter = nbt.func_74764_b("filter") ? ItemFilterProvider.load((NBTTagCompound)nbt.func_74775_l("filter")) : null;
        this.content = nbt.func_74764_b("item") ? new ItemStack(nbt.func_74775_l("item")) : null;
    }

    @Override
    protected boolean onDataPacket(NBTTagCompound nbt) {
        this.content = nbt.func_150297_b("it", 10) ? new ItemStack(nbt.func_74775_l("it")) : null;
        byte f = nbt.func_74771_c("filt");
        if (f == -1 ^ this.filter != null) {
            return false;
        }
        this.filter = f == -1 ? null : new DummyFilter(f);
        return true;
    }

    @Override
    protected void getUpdatePacket(NBTTagCompound nbt) {
        nbt.func_74774_a("filt", (byte)(this.filter == null ? -1 : (this.filter.blocking() ? 2 : 0)));
        if (this.last != null) {
            nbt.func_74782_a("it", (NBTBase)((ItemStack)this.last).func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        List<ItemStack> list = super.dropItem(state, fortune);
        if (this.content != null) {
            list.add((ItemStack)this.content);
        }
        if (this.filter != null) {
            list.add(this.filter.getItemStack());
        }
        return list;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 && !this.cover.opaque;
    }

    private class Inventory
    extends AbstractInventory {
        private Inventory() {
        }

        public int insertAm(int slot, ItemStack item) {
            if ((ItemPipe.this.type & 1) == 0 && (ItemPipe.this.filter == null || ItemPipe.this.filter.matches((Object)item))) {
                return Math.min(64, item.func_77976_d());
            }
            return 0;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (ItemPipe.this.content != null && (ItemPipe.this.type & 1) != 0 && (ItemPipe.this.filter == null || ItemPipe.this.filter.matches(ItemPipe.this.content))) {
                return super.extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            ItemPipe.this.setItem(stack, slot);
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemPipe.this.getItem(slot);
        }
    }
}

