/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.tileentity;

import cd4017be.api.protect.PermissionUtil;
import cd4017be.indlog.tileentity.FluidIntake;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.ITankContainer;
import cd4017be.lib.Gui.SlotTank;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.capability.AdvancedTank;
import cd4017be.lib.tileentity.BaseTileEntity;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class FluidIO
extends BaseTileEntity
implements ITickable,
DataContainer.IGuiData,
BlockGuiHandler.ClientPacketReceiver,
AdvancedBlock.ITilePlaceHarvest {
    public static int CAP = 8000;
    public static int MAX_SIZE = 127;
    public static int SEARCH_MULT = 3;
    public static int SPEED = 1;
    protected GameProfile lastUser = PermissionUtil.DEFAULT_PLAYER;
    public AdvancedTank tank = new AdvancedTank((TileEntity)this, CAP, this instanceof FluidIntake);
    protected int[] blocks = new int[MAX_SIZE * SEARCH_MULT];
    protected int dist = -1;
    protected int lastStepDown = 0;
    protected boolean goUp;
    public boolean blockNotify;
    public int range;
    public int debugI;

    public void func_73660_a() {
        int target = this.blocks[this.dist];
        byte dx = (byte)target;
        byte dy = (byte)(target >> 8);
        byte dz = (byte)(target >> 16);
        if (this.dist >= this.blocks.length - 1) {
            this.moveBack(dx, dy, dz);
            return;
        }
        int ld0 = target >> 24 & 7;
        int ld1 = target >> 27 & 7;
        boolean canBack = (target & 0x40000000) != 0;
        EnumFacing dir = this.findNextDir(dx, dy, dz, ld0, ld1, canBack);
        if (dir != null) {
            ++this.dist;
            int s = dir.ordinal();
            if (s < 2) {
                target = 0;
                this.lastStepDown = this.dist;
            } else if (s != ld0) {
                target = s << 24 | ld0 << 27;
                if (this.dist == 0) {
                    target |= 0x40000000;
                }
            } else {
                EnumFacing ld;
                target &= 0x7F000000;
                if (!canBack && ld1 >= 2 && !this.isValidPos(dx - (ld = EnumFacing.field_82609_l[ld1]).func_82601_c(), dy, dz - ld.func_82599_e())) {
                    target |= 0x40000000;
                }
            }
            this.blocks[this.dist] = dx + dir.func_82601_c() & 0xFF | (dy + dir.func_96559_d() & 0xFF) << 8 | (dz + dir.func_82599_e() & 0xFF) << 16 | target;
        } else {
            this.moveBack(dx, dy, dz);
        }
    }

    protected EnumFacing findNextDir(int x, int y, int z, int ld0, int ld1, boolean canBack) {
        if (this.isValidPos(x, y + (this.goUp ? 1 : -1), z)) {
            return this.goUp ? EnumFacing.UP : EnumFacing.DOWN;
        }
        EnumFacing ld = EnumFacing.field_82609_l[ld0];
        if (ld0 >= 2 && this.isValidPos(x + ld.func_82601_c(), y, z + ld.func_82599_e())) {
            return ld;
        }
        if (ld0 < 2 || ld1 < 2) {
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                if (!this.isValidPos(x + dir.func_82601_c(), y, z + dir.func_82599_e())) continue;
                return dir;
            }
            return null;
        }
        ld = EnumFacing.field_82609_l[ld1];
        if (this.isValidPos(x + ld.func_82601_c(), y, z + ld.func_82599_e())) {
            return ld;
        }
        if (canBack && this.isValidPos(x - ld.func_82601_c(), y, z - ld.func_82599_e())) {
            return ld.func_176734_d();
        }
        return null;
    }

    protected boolean isValidPos(int x, int y, int z) {
        int l = this.range;
        if (x > l || -x > l || y > l || -y > l || z > l || -z > l || !this.canUse(this.field_174879_c.func_177982_a(x, y, z))) {
            return false;
        }
        int p = x & 0xFF | (y & 0xFF) << 8 | (z & 0xFF) << 16;
        for (int i = this.dist - 1; i >= this.lastStepDown; i -= 2) {
            if ((this.blocks[i] & 0xFFFFFF) != p) continue;
            return false;
        }
        return true;
    }

    protected void findPrevStepDown() {
        for (int i = this.dist; i > 0; --i) {
            if ((this.blocks[i] & 0x7000000) >= 2) continue;
            this.lastStepDown = i;
            return;
        }
        this.lastStepDown = 0;
    }

    protected abstract boolean canUse(BlockPos var1);

    protected abstract void moveBack(int var1, int var2, int var3);

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        return cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        return (T)(cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.tank : null);
    }

    public void onPacketFromClient(PacketBuffer data, EntityPlayer sender) throws IOException {
        switch (data.readByte()) {
            case 0: {
                this.blockNotify = !this.blockNotify;
                break;
            }
            case 1: {
                this.lastUser = sender.func_146103_bH();
                this.range = data.readByte();
                if (this.range < 0) {
                    this.range = 0;
                } else if (this.range > MAX_SIZE) {
                    this.range = MAX_SIZE;
                }
                this.setDist();
                break;
            }
            case 2: {
                if (this.tank.fluid == null) break;
                this.tank.decrement(this.tank.fluid.amount);
                break;
            }
            case 3: {
                this.tank.setLock(!this.tank.lock);
            }
        }
        this.func_70296_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("tank", (NBTBase)this.tank.writeNBT(new NBTTagCompound()));
        nbt.func_74768_a("mode", this.range & 0xFF | (this.blockNotify ? 256 : 0));
        PermissionUtil.writeOwner((NBTTagCompound)nbt, (GameProfile)this.lastUser);
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readNBT(nbt.func_74775_l("tank"));
        this.range = nbt.func_74762_e("mode");
        this.blockNotify = (this.range & 0x100) != 0;
        this.range &= 0xFF;
        this.lastUser = PermissionUtil.readOwner((NBTTagCompound)nbt);
        this.setDist();
    }

    protected void setDist() {
        int l = this.range;
        if (!PermissionUtil.handler.canEdit(this.field_145850_b, this.field_174879_c.func_177982_a(-l, -l, -l), this.field_174879_c.func_177982_a(l, l, l), this.lastUser)) {
            this.range = 0;
        }
        this.dist = -1;
        this.lastStepDown = 0;
    }

    public void initContainer(DataContainer cont) {
        TileContainer container = (TileContainer)cont;
        container.addTankSlot(new TileContainer.TankSlot((ITankContainer)this.tank, 0, 184, 16, 35));
        container.addItemSlot((Slot)new SlotTank((IItemHandler)this.tank, 0, 202, 34));
        container.addPlayerInventory(8, 16);
    }

    public int[] getSyncVariables() {
        return new int[]{this.range & 0xFF | (this.blockNotify ? 256 : 0) | (this.tank.lock ? 512 : 0), this.dist >= 0 ? this.blocks[this.dist] : 0};
    }

    public void setSyncVariable(int i, int v) {
        switch (i) {
            case 0: {
                this.range = v & 0xFF;
                this.blockNotify = (v & 0x100) != 0;
                this.tank.lock = (v & 0x200) != 0;
                break;
            }
            case 1: {
                this.debugI = v;
            }
        }
    }

    public boolean detectAndSendChanges(DataContainer container, PacketBuffer dos) {
        return false;
    }

    public void updateClientChanges(DataContainer container, PacketBuffer dis) {
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        List list = this.makeDefaultDrops(null);
        this.tank.addToList(list);
        return list;
    }
}

