/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.render.gui;

import cd4017be.indlog.render.RenderItemOverride;
import cd4017be.indlog.tileentity.Buffer;
import cd4017be.indlog.util.VariableInventory;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.AdvancedGui;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.TileContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class GuiItemBuffer
extends AdvancedGui {
    private final Buffer tile;
    private final int N;
    private final float StepSlot;
    private final float StepStack;

    public GuiItemBuffer(DataContainer.IGuiData tile, EntityPlayer player) {
        super((Container)new TileContainer(tile, player));
        this.tile = (Buffer)tile;
        this.MAIN_TEX = new ResourceLocation("indlog", "textures/gui/buffer.png");
        this.drawBG = (byte)6;
        this.N = this.tile.inventory.items.length;
        this.StepSlot = 1.0f / (float)Buffer.SLOTS[this.tile.type];
        this.StepStack = 1.0f / (float)Buffer.STACKS[this.tile.type];
    }

    public void func_73866_w_() {
        int ofs = (this.N + 11) / 12 * 18;
        this.field_146999_f = 230;
        this.field_147000_g = 114 + ofs;
        super.func_73866_w_();
        this.tabsY = ofs + 31;
        this.guiComps.add(new AdvancedGui.InfoTab((AdvancedGui)this, 0, 7, 6, 7, 8, "buffer.info"));
        this.guiComps.add(new AdvancedGui.Slider((AdvancedGui)this, 1, 194, 42 + ofs, 64, 230, 0, 10, 2, false).scroll(this.StepSlot));
        this.guiComps.add(new AdvancedGui.Slider((AdvancedGui)this, 2, 212, 42 + ofs, 64, 240, 0, 10, 2, false).scroll(this.StepStack));
        this.guiComps.add(new AdvancedGui.Slider((AdvancedGui)this, 3, 176, 42 + ofs, 64, 230, 2, 10, 2, false).scroll(this.StepSlot));
        this.guiComps.add(new AdvancedGui.Tooltip((AdvancedGui)this, 4, 194, 42 + ofs, 10, 64, "buffer.slots"));
        this.guiComps.add(new AdvancedGui.Tooltip((AdvancedGui)this, 5, 212, 42 + ofs, 10, 64, "buffer.stack"));
        this.guiComps.add(new AdvancedGui.Tooltip((AdvancedGui)this, 6, 176, 42 + ofs, 10, 64, "buffer.start"));
        this.guiComps.add(new AdvancedGui.Button((AdvancedGui)this, 7, 193, 17 + ofs, 12, 12, 0).texture(242, 29).setTooltip("buffer.side#"));
        this.guiComps.add(new AdvancedGui.Button((AdvancedGui)this, 8, 175, 17 + ofs, 12, 12, 0).texture(230, 17).setTooltip("buffer.reset"));
        this.guiComps.add(new AdvancedGui.Button((AdvancedGui)this, 9, 211, 17 + ofs, 12, 12, 0).texture(230, 107).setTooltip("buffer.lock#"));
        this.setEnabled(3, false);
        this.setEnabled(6, false);
    }

    protected Object getDisplVar(int id) {
        switch (id) {
            case 1: {
                return Float.valueOf(1.0f - (float)this.tile.getEnd() * this.StepSlot);
            }
            case 2: {
                return Float.valueOf(1.0f - (float)this.tile.inventory.stackSize * this.StepStack);
            }
            case 3: {
                return Float.valueOf(1.0f - (float)this.tile.getStart() * this.StepSlot);
            }
            case 4: {
                return new Object[]{this.tile.getEnd(), Buffer.SLOTS[this.tile.type]};
            }
            case 5: {
                return new Object[]{this.tile.inventory.stackSize, Buffer.STACKS[this.tile.type]};
            }
            case 6: {
                return this.tile.getStart();
            }
            case 7: {
                return (int)this.tile.selSide;
            }
            case 8: {
                return this.tile.selSide >= 0 && this.tile.sideAccs[this.tile.selSide] != null ? 0 : -1;
            }
            case 9: {
                return this.tile.inventory.locked ? 1 : 0;
            }
        }
        return null;
    }

    protected void setDisplVar(int id, Object obj, boolean send) {
        PacketBuffer data = BlockGuiHandler.getPacketTargetData((BlockPos)this.tile.pos());
        switch (id) {
            case 1: {
                int v = Math.round((1.0f - ((Float)obj).floatValue()) / this.StepSlot + 0.4f);
                v = Math.min(Math.max(v, 0), Buffer.SLOTS[this.tile.type]);
                if (this.tile.selSide < 0 || this.tile.selSide >= 6) {
                    data.writeByte(0);
                    this.tile.inventory.slots = v;
                    data.writeByte(this.tile.inventory.slots);
                    break;
                }
                data.writeByte(3);
                data.writeByte((int)this.tile.selSide);
                data.writeByte(this.tile.getStart());
                data.writeByte(v);
                VariableInventory.GroupAccess acc = this.tile.sideAccs[this.tile.selSide];
                if (acc == null) break;
                acc.setRange(acc.start, v);
                break;
            }
            case 2: {
                int v = Math.round((1.0f - ((Float)obj).floatValue()) / this.StepStack + 0.4f);
                data.writeByte(1);
                this.tile.inventory.stackSize = Math.min(Math.max(v, 1), Buffer.STACKS[this.tile.type]);
                data.writeInt(this.tile.inventory.stackSize);
                break;
            }
            case 3: {
                int v = Math.round((1.0f - ((Float)obj).floatValue()) / this.StepSlot + 0.4f);
                if (this.tile.selSide < 0 || this.tile.selSide >= 6) {
                    return;
                }
                data.writeByte(3);
                data.writeByte((int)this.tile.selSide);
                data.writeByte(v);
                data.writeByte(this.tile.getEnd());
                VariableInventory.GroupAccess acc = this.tile.sideAccs[this.tile.selSide];
                if (acc == null) break;
                acc.setRange(v, acc.start + acc.size);
                break;
            }
            case 7: {
                if ((Integer)obj == 0) {
                    this.tile.selSide = (byte)(this.tile.selSide + 1);
                    if (this.tile.selSide >= 6) {
                        this.tile.selSide = (byte)-1;
                    }
                } else {
                    this.tile.selSide = (byte)(this.tile.selSide - 1);
                    if (this.tile.selSide < -1) {
                        this.tile.selSide = (byte)5;
                    }
                }
                this.setEnabled(3, this.tile.selSide >= 0);
                this.setEnabled(6, this.tile.selSide >= 0);
                return;
            }
            case 8: {
                data.writeByte(2);
                data.writeByte((int)this.tile.selSide);
                break;
            }
            case 9: {
                data.writeByte(4);
            }
        }
        if (send) {
            BlockGuiHandler.sendPacketToServer((PacketBuffer)data);
        }
    }

    protected void func_146976_a(float t, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.MAIN_TEX);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, 15);
        int s = this.tile.getStart();
        int e = this.tile.getEnd();
        this.drawSlots(0, s, 132);
        this.drawSlots(s, e, 114);
        this.drawSlots(e, this.N, 132);
        this.drawSlots(this.N, (this.N + 11) / 12 * 12, 150);
        this.func_73729_b(this.field_147003_i, this.field_147009_r + this.field_147000_g - 99, 0, 15, this.field_146999_f, 99);
        if (this.tile.selSide >= 0) {
            this.func_73729_b(this.field_147003_i + 175, this.field_147009_r + this.field_147000_g - 85, 230, 29, 12, 78);
        }
        super.func_146976_a(t, mouseX, mouseY);
    }

    protected void func_146979_b(int mx, int my) {
        super.func_146979_b(mx, my);
        if (this.tile.selSide >= 0 && this.tile.selSide < 6) {
            this.drawSideCube(this.tabsX - 64, this.tabsY, this.tile.selSide, (byte)3);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.setEnabled(8, this.tile.selSide >= 0 && this.tile.selSide < 6 && this.tile.sideAccs[this.tile.selSide] != null);
    }

    private void drawSlots(int i0, int i1, int ty) {
        if (i1 <= i0) {
            return;
        }
        int w0 = i0 % 12 * 18 + 7;
        int w1 = i1 % 12 * 18 + 7;
        int h0 = i0 / 12;
        int h1 = i1 / 12;
        if (h0 == h1 && w0 > 7) {
            this.func_73729_b(this.field_147003_i + w0, this.field_147009_r + h0 * 18 + 15, w0, ty, w1 - w0, 18);
        } else {
            if (w0 > 7) {
                this.func_73729_b(this.field_147003_i + w0, this.field_147009_r + h0 * 18 + 15, w0, ty, this.field_146999_f - w0, 18);
                ++h0;
            }
            for (int h = h0; h < h1; ++h) {
                this.func_73729_b(this.field_147003_i, this.field_147009_r + h * 18 + 15, 0, ty, this.field_146999_f, 18);
            }
            if (w1 > 7) {
                this.func_73729_b(this.field_147003_i, this.field_147009_r + h1 * 18 + 15, 0, ty, w1, 18);
            }
        }
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        this.field_146296_j = RenderItemOverride.instance();
    }
}

