/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.item;

import cd4017be.api.indlog.filter.FluidFilterProvider;
import cd4017be.api.indlog.filter.ItemFilterProvider;
import cd4017be.indlog.filter.NameFilter;
import cd4017be.indlog.render.gui.GuiNameFilter;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.IGuiItem;
import cd4017be.lib.Gui.ItemGuiData;
import cd4017be.lib.item.BaseItem;
import cd4017be.lib.util.TooltipUtil;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemNameFilter
extends BaseItem
implements IGuiItem,
BlockGuiHandler.ClientItemPacketReceiver,
ItemFilterProvider,
FluidFilterProvider {
    public static int MAX_LENGTH = 20;

    public ItemNameFilter(String id) {
        super(id);
    }

    public void func_77624_a(ItemStack item, @Nullable World player, List<String> list, ITooltipFlag b) {
        if (item.func_77942_o()) {
            String s;
            String[] states = TooltipUtil.translate((String)"gui.cd4017be.filter.state").split(",");
            NameFilter.FluidFilter filter = this.getFluidFilter(item);
            if (states.length >= 11) {
                s = states[(filter.mode & 1) == 0 ? 0 : 1];
                if ((filter.mode & 8) != 0) {
                    s = s + states[8];
                }
                s = s + states[(filter.mode & 4) == 0 ? 9 : 10];
                if ((filter.mode & 2) != 0) {
                    s = s + states[5];
                }
                if ((filter.mode & 0x40) != 0) {
                    s = s + states[(filter.mode & 0x80) != 0 ? 7 : 6];
                }
            } else {
                s = "<invalid lang entry!>";
            }
            list.add(s);
            if (!filter.regex.isEmpty()) {
                list.add(TooltipUtil.format((String)"gui.cd4017be.pattern", (Object[])new Object[]{filter.regex}));
            }
            if (filter.priority != 0) {
                list.add(TooltipUtil.format((String)"gui.cd4017be.priority", (Object[])new Object[]{filter.priority}));
            }
        }
        super.func_77624_a(item, player, list, b);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        BlockGuiHandler.openItemGui((EntityPlayer)player, (EnumHand)hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
    }

    public Container getContainer(ItemStack item, EntityPlayer player, World world, BlockPos pos, int slot) {
        return new DataContainer((DataContainer.IGuiData)new ItemGuiData((Item)this), player);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(ItemStack item, EntityPlayer player, World world, BlockPos pos, int slot) {
        return new GuiNameFilter(new DataContainer((DataContainer.IGuiData)new ItemGuiData((Item)this), player));
    }

    public void onPacketFromClient(PacketBuffer dis, EntityPlayer player, ItemStack item, int slot) throws IOException {
        NBTTagCompound nbt;
        if (item.func_77942_o()) {
            nbt = item.func_77978_p();
        } else {
            nbt = new NBTTagCompound();
            item.func_77982_d(nbt);
        }
        byte cmd = dis.readByte();
        switch (cmd) {
            case 5: {
                nbt.func_74774_a("mode", dis.readByte());
                return;
            }
            case 6: {
                nbt.func_74778_a("regex", dis.func_150789_c(MAX_LENGTH));
                nbt.func_74774_a("mode", (byte)(nbt.func_74771_c("mode") & 0xFFFFFFEF));
                return;
            }
            case 7: {
                nbt.func_74774_a("prior", dis.readByte());
                return;
            }
        }
    }

    public NameFilter.FluidFilter getFluidFilter(ItemStack stack) {
        NameFilter.FluidFilter filter = new NameFilter.FluidFilter();
        if (stack != null && stack.func_77942_o()) {
            filter.deserializeNBT(stack.func_77978_p());
        }
        return filter;
    }

    public NameFilter.ItemFilter getItemFilter(ItemStack stack) {
        NameFilter.ItemFilter filter = new NameFilter.ItemFilter();
        if (stack != null && stack.func_77942_o()) {
            filter.deserializeNBT(stack.func_77978_p());
        }
        return filter;
    }
}

