/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.filter;

import cd4017be.api.indlog.filter.FilterBase;
import cd4017be.indlog.Objects;
import cd4017be.lib.util.ItemFluidUtil;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class PipeFilterFluid
extends FilterBase<FluidStack, IFluidHandler> {
    public int maxAmount;
    public Fluid[] list = new Fluid[0];

    public boolean active(boolean rs) {
        return (this.mode & 8) == 0 || rs ^ (this.mode & 4) != 0;
    }

    public int insertAmount(FluidStack stack, IFluidHandler inv) {
        if (stack == null) {
            return 0;
        }
        if (!this.matches(stack)) {
            return 0;
        }
        if (this.maxAmount == 0) {
            return stack.amount;
        }
        int am = this.maxAmount;
        for (IFluidTankProperties inf : ItemFluidUtil.listTanks((IFluidHandler)inv)) {
            FluidStack fluid = inf.getContents();
            if (fluid == null || !fluid.isFluidEqual(stack)) continue;
            am -= fluid.amount;
        }
        if (am <= 0) {
            return 0;
        }
        if (am >= stack.amount) {
            return stack.amount;
        }
        return am;
    }

    public FluidStack getExtract(FluidStack stack, IFluidHandler inv) {
        if (stack == null) {
            for (IFluidTankProperties inf : ItemFluidUtil.listTanks((IFluidHandler)inv)) {
                stack = inf.getContents();
                if (stack == null || !inf.canDrainFluidType(stack) || (stack = this.getExtract(stack, inv)) == null) continue;
                return stack;
            }
            return null;
        }
        if (!this.matches(stack)) {
            return null;
        }
        stack = inv.drain(stack, false);
        if (this.maxAmount > 0 && stack != null) {
            stack.amount -= this.maxAmount;
        }
        return stack;
    }

    public boolean transfer(FluidStack stack) {
        return (this.mode & 2) == 0 || stack != null && !this.matches(stack);
    }

    public boolean matches(FluidStack stack) {
        Fluid f = stack.getFluid();
        for (Fluid fluid : this.list) {
            if (f != fluid) continue;
            return (this.mode & 1) == 0;
        }
        return (this.mode & 1) != 0;
    }

    public boolean noEffect() {
        return this.list.length == 0 && (this.mode & 1) != 0 && this.maxAmount == 0;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74768_a("maxAm", this.maxAmount);
        if (this.list.length > 0) {
            NBTTagList list = new NBTTagList();
            for (Fluid fluid : this.list) {
                list.func_74742_a((NBTBase)new NBTTagString(fluid.getName()));
            }
            nbt.func_74782_a("Fluids", (NBTBase)list);
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.maxAmount = nbt.func_74762_e("maxAm");
        if (this.maxAmount < 0) {
            this.maxAmount = 0;
        }
        if (nbt.func_74764_b("Fluids")) {
            NBTTagList list = nbt.func_150295_c("Fluids", 8);
            this.list = new Fluid[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.list[i] = FluidRegistry.getFluid((String)list.func_150307_f(i));
            }
        }
        super.deserializeNBT(nbt);
    }

    public Item item() {
        return Objects.fluid_filter;
    }
}

