/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.varia;

import java.util.Optional;
import mcjty.immcraft.api.generic.GenericBlock;
import mcjty.immcraft.api.generic.GenericTE;
import mcjty.immcraft.blocks.generic.GenericImmcraftTE;
import mcjty.immcraft.blocks.generic.GenericInventoryTE;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTools {
    public static void placeBlock(World world, BlockPos pos, GenericBlock block, EntityPlayer player) {
        IBlockState state = block.func_176223_P().func_177226_a((IProperty)GenericBlock.FACING_HORIZ, (Comparable)player.func_174811_aO().func_176734_d());
        world.func_180501_a(pos, state, 2);
    }

    public static Block getBlock(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            return ((ItemBlock)stack.func_77973_b()).func_179223_d();
        }
        return null;
    }

    public static <T extends GenericTE> Optional<T> getTE(Class<T> clazz, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericImmcraftTE && (clazz == null || clazz.isInstance(te))) {
            return Optional.of((GenericTE)te);
        }
        return Optional.empty();
    }

    public static Optional<GenericInventoryTE> getInventoryTE(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericInventoryTE) {
            return Optional.of((GenericInventoryTE)te);
        }
        return Optional.empty();
    }

    public static Optional<GenericBlock> getBlock(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof GenericBlock) {
            return Optional.of((GenericBlock)block);
        }
        return Optional.empty();
    }

    public static boolean isTopValidAndSolid(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!block.isSideSolid(state, (IBlockAccess)world, pos, EnumFacing.UP)) {
            return false;
        }
        if (!block.func_149688_o(state).func_76220_a()) {
            return false;
        }
        return block.isNormalCube(state, (IBlockAccess)world, pos);
    }

    public static boolean isSideValidAndSolid(World world, BlockPos pos, EnumFacing side, Block block) {
        IBlockState state = world.func_180495_p(pos);
        if (!block.isSideSolid(state, (IBlockAccess)world, pos, side)) {
            return false;
        }
        if (!block.func_149688_o(state).func_76220_a()) {
            return false;
        }
        return block.isNormalCube(state, (IBlockAccess)world, pos);
    }
}

