/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.multiblock;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import mcjty.immcraft.multiblock.MultiBlockData;
import mcjty.immcraft.multiblock.MultiBlockNetwork;
import mcjty.immcraft.multiblock.MultiblockInfoPacketClient;
import mcjty.immcraft.network.InfoPacketClient;
import mcjty.immcraft.network.InfoPacketServer;
import mcjty.lib.network.NetworkTools;
import net.minecraft.entity.player.EntityPlayerMP;

public class MultiblockInfoPacketServer
implements InfoPacketServer {
    private String networkName;
    private int blockId;

    public MultiblockInfoPacketServer() {
    }

    public MultiblockInfoPacketServer(String networkName, int blockId) {
        this.networkName = networkName;
        this.blockId = blockId;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.networkName = NetworkTools.readString((ByteBuf)buf);
        this.blockId = buf.readInt();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        NetworkTools.writeString((ByteBuf)buf, (String)this.networkName);
        buf.writeInt(this.blockId);
    }

    @Override
    public Optional<InfoPacketClient> onMessageServer(EntityPlayerMP player) {
        MultiBlockData.get(player.func_130014_f_());
        MultiBlockNetwork network = MultiBlockData.getNetwork(this.networkName);
        if (network != null) {
            Object mb = network.getOrCreateMultiBlock(this.blockId);
            if (mb == null) {
                return Optional.empty();
            }
            return Optional.of(new MultiblockInfoPacketClient(this.networkName, this.blockId, mb.getClientInfo()));
        }
        return Optional.empty();
    }
}

