/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.books;

import mcjty.immcraft.ImmersiveCraft;
import mcjty.immcraft.setup.ClientProxy;
import mcjty.lib.font.TrueTypeFont;
import net.minecraft.item.EnumDyeColor;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;

public class TextElementFormat {
    private float scale = 1.0f;
    private EnumDyeColor color = EnumDyeColor.BLACK;
    private int align = -1;
    private int valign = -1;
    private boolean bold = false;
    private boolean italic = false;
    public static final TextElementFormat DEFAULT = new TextElementFormat("");

    public TextElementFormat(String fmt) {
        if (!fmt.isEmpty()) {
            String[] split;
            for (String s : split = StringUtils.split((String)fmt, (char)',')) {
                if (s.length() == 1 && Character.isDigit(s.charAt(0))) {
                    this.scale = 0.5f + (float)(fmt.charAt(0) - 48) * 0.4f;
                    continue;
                }
                if ("left".equals(s) || "l".equals(s)) {
                    this.align = -1;
                    continue;
                }
                if ("center".equals(s) || "c".equals(s)) {
                    this.align = 0;
                    continue;
                }
                if ("right".equals(s) || "r".equals(s)) {
                    this.align = 1;
                    continue;
                }
                if ("top".equals(s) || "t".equals(s)) {
                    this.valign = -1;
                    continue;
                }
                if ("vcenter".equals(s) || "vc".equals(s)) {
                    this.valign = 0;
                    continue;
                }
                if ("bottom".equals(s) || "b".equals(s)) {
                    this.valign = 1;
                    continue;
                }
                if ("bold".equals(s)) {
                    this.bold = true;
                    continue;
                }
                if ("italic".equals(s)) {
                    this.italic = true;
                    continue;
                }
                try {
                    this.color = EnumDyeColor.valueOf((String)s.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    ImmersiveCraft.setup.getLogger().log(Level.WARN, "Bad format for text: '" + fmt + "'!");
                }
            }
        }
    }

    public TrueTypeFont getFont() {
        if (this.bold) {
            return ClientProxy.font_bold;
        }
        if (this.italic) {
            return ClientProxy.font_italic;
        }
        return ClientProxy.font;
    }

    public void setColor(EnumDyeColor color) {
        this.color = color;
    }

    public float getScale() {
        return this.scale;
    }

    public EnumDyeColor getColor() {
        return this.color;
    }

    public int getAlign() {
        return this.align;
    }

    public int getValign() {
        return this.valign;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }
}

