/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.blocks.furnace;

import mcjty.immcraft.api.handles.IInterfaceHandle;
import mcjty.immcraft.api.helpers.NBTHelper;
import mcjty.immcraft.blocks.ModBlocks;
import mcjty.immcraft.blocks.furnace.FurnaceOutputInteractionHandler;
import mcjty.immcraft.blocks.generic.GenericInventoryTE;
import mcjty.immcraft.blocks.generic.handles.FuelInterfaceHandle;
import mcjty.immcraft.blocks.generic.handles.SmeltableInterfaceHandle;
import mcjty.immcraft.config.GeneralConfiguration;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class FurnaceTE
extends GenericInventoryTE
implements ITickable {
    public static final int SLOT_FUEL = 0;
    public static final int SLOT_TOBURN = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int FURNACE_COOKTIME = 200;
    private int burnTime = 0;
    private int cookTime = 0;
    private IItemHandler handlerUp = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    private IItemHandler handlerDown = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    private IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.SOUTH);

    public FurnaceTE() {
        super(3);
        this.addInterfaceHandle((IInterfaceHandle)new FuelInterfaceHandle("fuel").slot(0));
        this.addInterfaceHandle((IInterfaceHandle)new SmeltableInterfaceHandle("input").slot(1));
        this.addInterfaceHandle((IInterfaceHandle)new FurnaceOutputInteractionHandler("output").slot(2));
    }

    public void func_73660_a() {
        if (this.burnTime > 0) {
            this.markDirtyQuick();
            this.handleBurn();
            this.handleMelt();
            if (GeneralConfiguration.willRainExtinguishTheFurnace && this.func_145831_w().func_72896_J() && this.func_145831_w().func_175678_i(this.field_174879_c)) {
                this.burnTime = 0;
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.5, (double)this.func_174877_v().func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        if (this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        EnumFacing direction = ModBlocks.furnaceBlock.worldToBlockSpace(this.func_145831_w(), this.func_174877_v(), side);
        if (direction == EnumFacing.UP) {
            return new int[]{1};
        }
        if (direction == EnumFacing.DOWN) {
            return new int[]{2};
        }
        return new int[]{0};
    }

    private void handleBurn() {
        int burnValue = TileEntityFurnace.func_145952_a((ItemStack)this.inventoryHelper.getStackInSlot(0));
        --this.burnTime;
        if (this.burnTime <= 0) {
            if (burnValue > 0) {
                this.burnTime = burnValue + 1;
            }
            if (this.burnTime > 0) {
                this.func_70298_a(0, 1);
            }
        }
    }

    private void handleMelt() {
        if (this.cookTime <= 0) {
            if (this.inventoryHelper.hasStack(1)) {
                this.cookTime = 200;
            }
        } else {
            --this.cookTime;
            if (this.cookTime <= 0 && this.inventoryHelper.hasStack(1)) {
                ItemStack tosmelt = this.inventoryHelper.decrStackSize(1, 1);
                ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(tosmelt);
                boolean undo = false;
                if (!result.func_190926_b()) {
                    if (!this.inventoryHelper.hasStack(2)) {
                        this.inventoryHelper.setInventorySlotContents(result.func_77976_d(), 2, result.func_77946_l());
                    } else if (result.func_77969_a(this.inventoryHelper.getStackInSlot(2))) {
                        if (result.func_190916_E() + this.inventoryHelper.getStackInSlot(2).func_190916_E() <= result.func_77976_d()) {
                            this.inventoryHelper.getStackInSlot(2).func_190917_f(result.func_190916_E());
                        } else {
                            undo = true;
                            this.cookTime = 40;
                        }
                    }
                } else {
                    undo = true;
                }
                if (undo) {
                    this.cookTime = 40;
                    if (this.inventoryHelper.hasStack(1)) {
                        this.inventoryHelper.getStackInSlot(1).func_190917_f(1);
                    } else {
                        this.inventoryHelper.setStackInSlot(1, tosmelt);
                    }
                }
            }
        }
        this.markDirtyClient();
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    @Override
    public boolean onActivate(EntityPlayer player) {
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (!stack.func_190926_b() && GeneralConfiguration.validIgnitionSources.contains(stack.func_77973_b())) {
            if (this.burnTime == 0) {
                this.burnTime = TileEntityFurnace.func_145952_a((ItemStack)this.inventoryHelper.getStackInSlot(0));
                if (this.burnTime > 0) {
                    this.func_70298_a(0, 1);
                }
            }
            this.markDirtyClient();
            if (GeneralConfiguration.ignitionSourcesConsume.contains(stack.func_77973_b())) {
                stack.func_190918_g(1);
            } else {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            return true;
        }
        return super.onActivate(player);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.burnTime = tagCompound.func_74762_e("burnTime");
        this.cookTime = tagCompound.func_74762_e("cookTime");
    }

    @Override
    public void writeToNBT(NBTHelper helper) {
        super.writeToNBT(helper);
        helper.set("burnTime", this.burnTime).set("cookTime", this.cookTime);
    }

    @Override
    public ItemStack func_70298_a(int index, int amount) {
        this.markDirtyClient();
        return super.func_70298_a(index, amount);
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        this.markDirtyClient();
        super.func_70299_a(index, stack);
    }

    @Override
    public ItemStack func_70304_b(int index) {
        this.markDirtyClient();
        return super.func_70304_b(index);
    }

    @Override
    protected IItemHandler getItemHandlerForSide(EnumFacing facing) {
        if (facing == EnumFacing.UP) {
            return this.handlerUp;
        }
        if (facing == EnumFacing.DOWN) {
            return this.handlerDown;
        }
        if (facing != null) {
            return this.handlerSide;
        }
        return super.getItemHandlerForSide(null);
    }
}

