/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.blocks.bundle;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mcjty.immcraft.api.block.IOrientedBlock;
import mcjty.immcraft.api.cable.IBundle;
import mcjty.immcraft.api.cable.ICable;
import mcjty.immcraft.api.cable.ICableConnector;
import mcjty.immcraft.api.cable.ICableHandler;
import mcjty.immcraft.api.cable.ICableSection;
import mcjty.immcraft.api.cable.ICableSubType;
import mcjty.immcraft.api.cable.ICableType;
import mcjty.immcraft.api.helpers.IntersectionTools;
import mcjty.immcraft.api.helpers.InventoryHelper;
import mcjty.immcraft.api.helpers.NBTHelper;
import mcjty.immcraft.blocks.generic.GenericImmcraftTE;
import mcjty.immcraft.cables.CableSection;
import mcjty.immcraft.multiblock.MultiBlockCableHelper;
import mcjty.immcraft.multiblock.MultiBlockData;
import mcjty.immcraft.multiblock.MultiBlockNetwork;
import mcjty.immcraft.varia.BlockTools;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public class BundleTE
extends GenericImmcraftTE
implements ITickable,
IBundle {
    private final List<CableSection> cableSections = new ArrayList<CableSection>();

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            MultiBlockData.get(this.func_145831_w());
            this.cableSections.stream().forEach(p -> p.getType().getCableHandler().tick(this, (ICableSection)p));
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public List<CableSection> getCableSections() {
        return this.cableSections;
    }

    @Override
    public ICableSection findSection(ICableType type, ICableSubType subType, int id) {
        for (CableSection section : this.cableSections) {
            if (section.getType() != type || section.getSubType() != subType || section.getId() != id) continue;
            return section;
        }
        return null;
    }

    public CableSection findConnectableSection(ICableType type, ICableSubType subType, Set<Integer> excluded) {
        Optional<CableSection> section = this.cableSections.stream().filter(p -> this.cableWithNoConnections((CableSection)p, type, subType, excluded)).findFirst();
        if (section.isPresent()) {
            return section.get();
        }
        return this.cableSections.stream().filter(p -> this.cableWithOneConnection((CableSection)p, type, subType, excluded)).findFirst().orElse(null);
    }

    private boolean cableWithNoConnections(CableSection p, ICableType type, ICableSubType subType, Set<Integer> excluded) {
        return !excluded.contains(p.getId()) && p.getType() == type && p.getSubType() == subType && p.getConnection(0) == null && p.getConnection(1) == null;
    }

    private boolean cableWithOneConnection(CableSection p, ICableType type, ICableSubType subType, Set<Integer> excluded) {
        return !excluded.contains(p.getId()) && p.getType() == type && p.getSubType() == subType && (p.getConnection(0) == null || p.getConnection(1) == null);
    }

    private void disconnectFromConnector(ICableType type, ICableSubType subType, int id, BlockPos current) {
        BundleTE bundle = BlockTools.getTE(BundleTE.class, (IBlockAccess)this.func_145831_w(), current).get();
        ICableSection isection = bundle.findSection(type, subType, id);
        CableSection section = (CableSection)isection;
        if (section.getConnectorID(0) != -1 && section.getConnector(this.func_145831_w(), 0) != null) {
            section.getConnector(this.func_145831_w(), 0).disconnect(section.getConnectorID(0));
            section.setConnection(0, null, null, -1);
        }
        if (section.getConnectorID(1) != -1 && section.getConnector(this.func_145831_w(), 1) != null) {
            section.getConnector(this.func_145831_w(), 1).disconnect(section.getConnectorID(1));
            section.setConnection(1, null, null, -1);
        }
    }

    private Vec3d getVectorFromCable(BlockPos c, ICableType type, ICableSubType subType, int id) {
        BundleTE bundle = BlockTools.getTE(BundleTE.class, (IBlockAccess)this.func_145831_w(), c).get();
        CableSection section = (CableSection)bundle.findSection(type, subType, id);
        return section.getVector();
    }

    public void addCableToNetwork(ICableType type, ICableSubType subType, Vec3d vector) {
        ICableHandler cableHandler = type.getCableHandler();
        String networkName = cableHandler.getNetworkName(subType);
        MultiBlockNetwork network = MultiBlockData.getNetwork(networkName);
        int id = MultiBlockCableHelper.addBlockToNetwork(network, type, subType, -1, this.func_145831_w(), this.func_174877_v());
        MultiBlockData.get(this.field_145850_b).save();
        CableSection section = new CableSection(type, subType, id, vector);
        this.cableSections.add(section);
        this.reconnectCable(cableHandler.getCable(this.func_145831_w(), subType, id), type, subType, id);
    }

    private void reconnectCable(ICable cable, ICableType type, ICableSubType subType, int id) {
        List<BlockPos> path = cable.getPath();
        List vectors = path.stream().map(p -> this.getVectorFromCable((BlockPos)p, type, subType, id)).collect(Collectors.toList());
        this.disconnectFromConnector(type, subType, id, path.get(0));
        this.disconnectFromConnector(type, subType, id, path.get(path.size() - 1));
        for (int i = 0; i < path.size(); ++i) {
            BlockPos current = path.get(i);
            BundleTE bundle = BlockTools.getTE(BundleTE.class, (IBlockAccess)this.func_145831_w(), current).get();
            CableSection section = (CableSection)bundle.findSection(type, subType, id);
            ICableConnector connector = null;
            if (i <= 0) {
                connector = this.tryConnectToConnector(section, id, 0, bundle.func_174877_v(), null);
            } else {
                section.setConnection(0, path.get(i - 1), IntersectionTools.intersectAtGrid(current, path.get(i - 1), (Vec3d)vectors.get(i), (Vec3d)vectors.get(i - 1)), -1);
            }
            if (i >= path.size() - 1) {
                this.tryConnectToConnector(section, id, 1, bundle.func_174877_v(), connector);
            } else {
                section.setConnection(1, path.get(i + 1), IntersectionTools.intersectAtGrid(current, path.get(i + 1), (Vec3d)vectors.get(i), (Vec3d)vectors.get(i + 1)), -1);
            }
            bundle.markDirtyClient();
        }
    }

    private ICableConnector tryConnectToConnector(CableSection section, int networkId, int directionId, BlockPos pos, ICableConnector alreadyConnected) {
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            BlockPos adj = pos.func_177972_a(direction);
            TileEntity te = this.func_145831_w().func_175625_s(adj);
            if (!(te instanceof ICableConnector) || te == alreadyConnected) continue;
            IOrientedBlock orientedBlock = (IOrientedBlock)this.func_145831_w().func_180495_p(adj).func_177230_c();
            EnumFacing blockSide = orientedBlock.worldToBlockSpace(this.func_145831_w(), adj, direction.func_176734_d());
            ICableConnector connector = (ICableConnector)te;
            if (connector.getType() != section.getType() || !connector.canConnect(blockSide)) continue;
            int connectorId = connector.connect(blockSide, networkId, section.getSubType());
            EnumFacing frontDirection = orientedBlock.getFrontDirection(this.func_145831_w().func_180495_p(adj));
            section.setConnection(directionId, adj, connector.getConnectorLocation(connectorId, frontDirection), connectorId);
            return connector;
        }
        return null;
    }

    public int countCableEndPoints(ICableType type, ICableSubType subType) {
        return (int)this.cableSections.stream().filter(s -> s.getType() == type && s.getSubType() == subType && (s.getConnection(0) == null || s.getConnection(1) == null)).count();
    }

    public void removeAllCables() {
        new ArrayList<CableSection>(this.cableSections).stream().forEach(this::removeCableFromNetwork);
    }

    public void removeCableFromNetwork(CableSection section) {
        this.disconnectCable(section);
        ICableHandler cableHandler = section.getType().getCableHandler();
        String networkName = cableHandler.getNetworkName(section.getSubType());
        MultiBlockNetwork network = MultiBlockData.getNetwork(networkName);
        MultiBlockCableHelper.removeBlockFromNetwork(network, section.getType(), section.getSubType(), section.getId(), this.func_145831_w(), this.func_174877_v());
        MultiBlockData.get(this.field_145850_b).save();
        this.cableSections.remove(section);
        this.markDirtyClient();
        section.getSubType().getBlock().ifPresent(block -> InventoryHelper.spawnItemStack(this.func_145831_w(), this.func_174877_v(), new ItemStack(block)));
    }

    public void disconnectCable(CableSection section) {
        for (int i = 0; i < 2; ++i) {
            BlockPos connection = section.getConnection(i);
            if (connection != null) {
                BlockTools.getTE(BundleTE.class, (IBlockAccess)this.func_145831_w(), connection).ifPresent(p -> this.disconnectOther((BundleTE)p, section));
            }
            section.releaseConnector(this.func_145831_w(), i);
            section.setConnection(i, null, null, -1);
        }
        this.markDirtyClient();
    }

    private void disconnectOther(BundleTE other, CableSection thisSection) {
        CableSection otherSection = (CableSection)other.findSection(thisSection.getType(), thisSection.getSubType(), thisSection.getId());
        other.disconnectFrom(otherSection, this.func_174877_v());
        other.markDirtyClient();
    }

    public void disconnectFrom(CableSection section, BlockPos other) {
        if (section == null) {
            return;
        }
        if (other.equals((Object)section.getConnection(0))) {
            section.releaseConnector(this.func_145831_w(), 0);
            section.setConnection(0, null, null, -1);
        } else if (other.equals((Object)section.getConnection(1))) {
            section.releaseConnector(this.func_145831_w(), 1);
            section.setConnection(1, null, null, -1);
        }
    }

    public void checkConnections() {
        for (CableSection section : this.cableSections) {
            for (int i = 0; i < 2; ++i) {
                TileEntity te;
                BlockPos connection;
                int id = section.getConnectorID(i);
                if (id == -1 || (connection = section.getConnection(i)) == null || (te = this.func_145831_w().func_175625_s(connection)) instanceof ICableConnector) continue;
                System.out.println("Connector removed");
                section.setConnection(i, null, null, -1);
                this.markDirtyClient();
            }
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        int size = tagCompound.func_74762_e("size");
        this.cableSections.clear();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound tc = (NBTTagCompound)tagCompound.func_74781_a("c" + i);
            if (tc == null) continue;
            this.cableSections.add(new CableSection(tc));
        }
    }

    @Override
    protected void writeToNBT(NBTHelper helper) {
        super.writeToNBT(helper);
        helper.set("size", this.cableSections.size());
        int i = 0;
        for (CableSection section : this.cableSections) {
            helper.set("c" + i, section.writeToNBT(NBTHelper.create()).get());
            ++i;
        }
    }
}

