/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.blocks.bundle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import mcjty.immcraft.api.util.Vector;
import mcjty.immcraft.blocks.bundle.BundleBlock;
import mcjty.immcraft.cables.CableSectionRender;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

public class BundleISBM
implements IBakedModel {
    public static final float THICK = 0.0625f;
    public static final ModelResourceLocation BAKED_MODEL = new ModelResourceLocation("immcraft:bundle");
    private TextureAtlasSprite bundleSprite;
    private VertexFormat format;
    private final float CT = 0.1f;
    private static final Map<String, TextureAtlasSprite> sprites = new HashMap<String, TextureAtlasSprite>();

    public BundleISBM(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this.format = format;
        this.bundleSprite = bakedTextureGetter.apply(new ResourceLocation("immcraft", "blocks/bundle"));
    }

    private void putVertex(UnpackedBakedQuad.Builder builder, Vec3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite) {
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            switch (this.format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (this.format.func_177348_c(e).func_177369_e() == 0) {
                        u = sprite.func_94214_a((double)u);
                        v = sprite.func_94207_b((double)v);
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    private BakedQuad createQuad(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, TextureAtlasSprite sprite) {
        Vec3d n = v2.func_178788_d(v1).func_72431_c(v3.func_178788_d(v1)).func_72432_b();
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        builder.setTexture(sprite);
        this.putVertex(builder, n, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0f, 0.0f, sprite);
        this.putVertex(builder, n, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, 0.0f, 16.0f, sprite);
        this.putVertex(builder, n, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, 16.0f, 16.0f, sprite);
        this.putVertex(builder, n, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, 16.0f, 0.0f, sprite);
        return builder.build();
    }

    private BakedQuad createOrientedQuad(Vec3d inside, Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, TextureAtlasSprite sprite, boolean inwards) {
        Vec3d normal = v1.func_178788_d(v2).func_72431_c(v3.func_178788_d(v2));
        if (inside.func_178788_d(v2).func_72430_b(normal) < 0.0 != inwards) {
            return this.createQuad(v4, v3, v2, v1, sprite);
        }
        return this.createQuad(v1, v2, v3, v4, sprite);
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.bundleSprite;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (state == null || side != null) {
            return Collections.emptyList();
        }
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        List cables = (List)extendedBlockState.getValue((IUnlistedProperty)BundleBlock.CABLES);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (CableSectionRender section : cables) {
            String textureName = section.getSubType().getTextureName();
            TextureAtlasSprite sprite = sprites.get(textureName);
            if (sprite == null) {
                sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(textureName);
                sprites.put(textureName, sprite);
            }
            this.addCable(section, sprite, quads);
        }
        return quads;
    }

    private void addCable(CableSectionRender section, TextureAtlasSprite sprite, List<BakedQuad> quads) {
        Vec3d vector = section.getVector();
        Vec3d vector1 = section.getVector1();
        if (vector1 == null) {
            vector1 = new Vec3d(vector.field_72450_a + (double)0.1f, vector.field_72448_b + (double)0.1f, vector.field_72449_c + (double)0.1f);
        }
        Vec3d vector2 = section.getVector2();
        this.addCablePart(quads, vector, vector1, sprite);
        if (vector2 != null) {
            this.addCablePart(quads, vector2, vector, sprite);
        }
    }

    private void addCablePart(List<BakedQuad> quads, Vec3d vector1, Vec3d vector2, TextureAtlasSprite sprite) {
        Pair<Vec3d, Vec3d> vectorPair = Vector.calculatePerpendicularVector(vector1, vector2);
        Vec3d v1 = ((Vec3d)vectorPair.getLeft()).func_72432_b().func_186678_a((double)0.1f);
        Vec3d v2 = ((Vec3d)vectorPair.getRight()).func_72432_b().func_186678_a((double)0.1f);
        Vec3d center = vector1.func_178787_e(vector2).func_186678_a(0.5);
        Vec3d s1 = vector1.func_178787_e(v1).func_178787_e(v2);
        Vec3d s2 = vector2.func_178787_e(v1).func_178787_e(v2);
        Vec3d s3 = vector2.func_178787_e(v1).func_178788_d(v2);
        Vec3d s4 = vector1.func_178787_e(v1).func_178788_d(v2);
        Vec3d s5 = vector2.func_178788_d(v1).func_178788_d(v2);
        Vec3d s6 = vector1.func_178788_d(v1).func_178788_d(v2);
        Vec3d s7 = vector2.func_178788_d(v1).func_178787_e(v2);
        Vec3d s8 = vector1.func_178788_d(v1).func_178787_e(v2);
        quads.add(this.createOrientedQuad(center, s1, s2, s3, s4, sprite, false));
        quads.add(this.createOrientedQuad(center, s4, s3, s5, s6, sprite, false));
        quads.add(this.createOrientedQuad(center, s6, s5, s7, s8, sprite, false));
        quads.add(this.createOrientedQuad(center, s8, s7, s2, s1, sprite, false));
        quads.add(this.createOrientedQuad(center, s1, s4, s6, s8, sprite, false));
        quads.add(this.createOrientedQuad(center, s7, s5, s3, s2, sprite, false));
    }
}

