/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.api.helpers;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class IntersectionTools {
    private static final float EPSILON = 0.001f;

    public static float calculateRayToLineDistance(Vec3d rayOrigin, Vec3d rayVec, Vec3d lineStart, Vec3d lineEnd) {
        float tN;
        float sN;
        float D;
        Vec3d u = rayVec;
        Vec3d v = lineEnd.func_178788_d(lineStart);
        Vec3d w = rayOrigin.func_178788_d(lineStart);
        float a = (float)u.func_72430_b(u);
        float b = (float)u.func_72430_b(v);
        float c = (float)v.func_72430_b(v);
        float d = (float)u.func_72430_b(w);
        float e = (float)v.func_72430_b(w);
        float sD = D = a * c - b * b;
        float tD = D;
        if (D < 0.001f) {
            sN = 0.0f;
            sD = 1.0f;
            tN = e;
            tD = c;
        } else {
            sN = b * e - c * d;
            tN = a * e - b * d;
            if (sN < 0.0f) {
                sN = 0.0f;
                tN = e;
                tD = c;
            }
        }
        if (tN < 0.0f) {
            tN = 0.0f;
            if (-d < 0.0f) {
                sN = 0.0f;
            } else {
                sN = -d;
                sD = a;
            }
        } else if (tN > tD) {
            tN = tD;
            if ((double)(-d + b) < 0.0) {
                sN = 0.0f;
            } else {
                sN = -d + b;
                sD = a;
            }
        }
        float sc = Math.abs(sN) < 0.001f ? 0.0f : sN / sD;
        float tc = Math.abs(tN) < 0.001f ? 0.0f : tN / tD;
        Vec3d dP = w.func_178787_e(u.func_186678_a((double)sc)).func_178788_d(v.func_186678_a((double)tc));
        return (float)dP.func_72433_c();
    }

    public static RayTraceResult getMovingObjectPositionFromPlayer(World world, EntityPlayer player, boolean stopOnLiquid) {
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C);
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B);
        double doubleX = player.field_70169_q + (player.field_70165_t - player.field_70169_q);
        double doubleY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) + (double)(world.field_72995_K ? player.func_70047_e() - player.getDefaultEyeHeight() : player.func_70047_e());
        double doubleZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s);
        Vec3d start = new Vec3d(doubleX, doubleY, doubleZ);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 5.0;
        if (player instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3d end = start.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(start, end, stopOnLiquid, !stopOnLiquid, false);
    }

    public static List<RayTraceResult> rayTest(World world, Vec3d start, Vec3d end, boolean stopOnLiquid, boolean ignoreBlocksWithoutBoundingbox, boolean returnLastUncollidableBlock) {
        return null;
    }

    public static Vec3d intersectAtGrid(BlockPos c1, BlockPos c2, Vec3d v1, Vec3d v2) {
        if (c1.func_177958_n() == c2.func_177958_n() && c1.func_177952_p() == c2.func_177952_p()) {
            float yval = c1.func_177956_o() < c2.func_177956_o() ? (float)c2.func_177956_o() : (float)c1.func_177956_o();
            float r = (float)(((double)yval - v1.field_72448_b) / (v2.field_72448_b - v1.field_72448_b));
            return new Vec3d((double)r * (v2.field_72450_a - v1.field_72450_a) + v1.field_72450_a, (double)yval, (double)r * (v2.field_72449_c - v1.field_72449_c) + v1.field_72449_c);
        }
        if (c1.func_177958_n() == c2.func_177958_n() && c1.func_177956_o() == c2.func_177956_o()) {
            float zval = c1.func_177952_p() < c2.func_177952_p() ? (float)c2.func_177952_p() : (float)c1.func_177952_p();
            float r = (float)(((double)zval - v1.field_72449_c) / (v2.field_72449_c - v1.field_72449_c));
            return new Vec3d((double)r * (v2.field_72450_a - v1.field_72450_a) + v1.field_72450_a, (double)r * (v2.field_72448_b - v1.field_72448_b) + v1.field_72448_b, (double)zval);
        }
        if (c1.func_177956_o() == c2.func_177956_o() && c1.func_177952_p() == c2.func_177952_p()) {
            float xval = c1.func_177958_n() < c2.func_177958_n() ? (float)c2.func_177958_n() : (float)c1.func_177958_n();
            float r = (float)(((double)xval - v1.field_72450_a) / (v2.field_72450_a - v1.field_72450_a));
            return new Vec3d((double)xval, (double)r * (v2.field_72448_b - v1.field_72448_b) + v1.field_72448_b, (double)r * (v2.field_72449_c - v1.field_72449_c) + v1.field_72449_c);
        }
        return new Vec3d((v1.field_72450_a + v2.field_72450_a) / 2.0, (v1.field_72448_b + v2.field_72448_b) / 2.0, (v1.field_72449_c + v2.field_72449_c) / 2.0);
    }
}

