/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.plug;

import buildcraft.api.facades.IFacadePhasedState;
import buildcraft.api.facades.IFacadeState;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.silicon.plug.FacadeBlockStateInfo;
import buildcraft.silicon.plug.FacadeStateManager;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;

public class FacadePhasedState
implements IFacadePhasedState {
    public final FacadeBlockStateInfo stateInfo;
    @Nullable
    public final EnumDyeColor activeColour;

    public FacadePhasedState(FacadeBlockStateInfo stateInfo, EnumDyeColor activeColour) {
        this.stateInfo = stateInfo;
        this.activeColour = activeColour;
    }

    public static FacadePhasedState readFromNbt(NBTTagCompound nbt) {
        FacadeBlockStateInfo stateInfo = FacadeStateManager.defaultState;
        if (nbt.func_74764_b("state")) {
            try {
                IBlockState blockState = NBTUtil.func_190008_d((NBTTagCompound)nbt.func_74775_l("state"));
                stateInfo = (FacadeBlockStateInfo)FacadeStateManager.validFacadeStates.get(blockState);
                if (stateInfo == null) {
                    stateInfo = FacadeStateManager.defaultState;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed badly when reading a facade state!", t);
            }
        }
        EnumDyeColor colour = (EnumDyeColor)NBTUtilBC.readEnum((NBTBase)nbt.func_74781_a("activeColour"), EnumDyeColor.class);
        return new FacadePhasedState(stateInfo, colour);
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        try {
            nbt.func_74782_a("state", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.stateInfo.state));
        }
        catch (Throwable t) {
            throw new IllegalStateException("Writing facade block state\n\tState = " + this.stateInfo + "\n\tBlock = " + this.stateInfo.state.func_177230_c() + "\n\tBlock Class = " + this.stateInfo.state.func_177230_c().getClass(), t);
        }
        if (this.activeColour != null) {
            nbt.func_74782_a("activeColour", NBTUtilBC.writeEnum((Enum)this.activeColour));
        }
        return nbt;
    }

    public static FacadePhasedState readFromBuffer(PacketBufferBC buf) {
        IBlockState state = MessageUtil.readBlockState((PacketBuffer)buf);
        EnumDyeColor colour = (EnumDyeColor)MessageUtil.readEnumOrNull((ByteBuf)buf, EnumDyeColor.class);
        FacadeBlockStateInfo info = (FacadeBlockStateInfo)FacadeStateManager.validFacadeStates.get(state);
        if (info == null) {
            info = FacadeStateManager.defaultState;
        }
        return new FacadePhasedState(info, colour);
    }

    public void writeToBuffer(PacketBufferBC buf) {
        try {
            MessageUtil.writeBlockState((PacketBuffer)buf, (IBlockState)this.stateInfo.state);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Writing facade block state\n\tState = " + this.stateInfo.state, t);
        }
        MessageUtil.writeEnumOrNull((ByteBuf)buf, (Enum)this.activeColour);
    }

    public FacadePhasedState withColour(EnumDyeColor colour) {
        return new FacadePhasedState(this.stateInfo, colour);
    }

    public boolean isSideSolid(EnumFacing side) {
        return this.stateInfo.isSideSolid[side.ordinal()];
    }

    public BlockFaceShape getBlockFaceShape(EnumFacing side) {
        return this.stateInfo.blockFaceShape[side.ordinal()];
    }

    public String toString() {
        return (this.activeColour == null ? "" : this.activeColour + " ") + this.getState();
    }

    public IFacadeState getState() {
        return this.stateInfo;
    }

    public EnumDyeColor getActiveColor() {
        return this.activeColour;
    }
}

