/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.client.model.plug;

import buildcraft.api.BCModules;
import buildcraft.api.transport.pluggable.IPluggableStaticBaker;
import buildcraft.api.transport.pluggable.PluggableModelKey;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.client.model.MutableVertex;
import buildcraft.lib.misc.VecUtil;
import buildcraft.silicon.client.model.key.KeyPlugFacade;
import buildcraft.transport.BCTransportModels;
import buildcraft.transport.client.model.key.KeyPlugBlocker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public enum PlugBakerFacade implements IPluggableStaticBaker<KeyPlugFacade>
{
    INSTANCE;


    private int getVertexIndex(List<Vec3d> positions, EnumFacing.Axis axis, boolean minOrMax1, boolean minOrMax2) {
        EnumFacing.Axis axis2;
        EnumFacing.Axis axis1;
        switch (axis) {
            case X: {
                axis1 = EnumFacing.Axis.Y;
                axis2 = EnumFacing.Axis.Z;
                break;
            }
            case Y: {
                axis1 = EnumFacing.Axis.X;
                axis2 = EnumFacing.Axis.Z;
                break;
            }
            case Z: {
                axis1 = EnumFacing.Axis.X;
                axis2 = EnumFacing.Axis.Y;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        double min1 = positions.stream().mapToDouble(pos -> VecUtil.getValue((Vec3d)pos, (EnumFacing.Axis)axis1)).min().orElse(0.0);
        double min2 = positions.stream().mapToDouble(pos -> VecUtil.getValue((Vec3d)pos, (EnumFacing.Axis)axis2)).min().orElse(0.0);
        double max1 = positions.stream().mapToDouble(pos -> VecUtil.getValue((Vec3d)pos, (EnumFacing.Axis)axis1)).max().orElse(0.0);
        double max2 = positions.stream().mapToDouble(pos -> VecUtil.getValue((Vec3d)pos, (EnumFacing.Axis)axis2)).max().orElse(0.0);
        double center1 = (min1 + max1) / 2.0;
        double center2 = (min2 + max2) / 2.0;
        return positions.indexOf(positions.stream().filter(pos -> (minOrMax1 ? VecUtil.getValue((Vec3d)pos, (EnumFacing.Axis)axis1) < center1 : VecUtil.getValue((Vec3d)pos, (EnumFacing.Axis)axis1) > center1) && (minOrMax2 ? VecUtil.getValue((Vec3d)pos, (EnumFacing.Axis)axis2) < center2 : VecUtil.getValue((Vec3d)pos, (EnumFacing.Axis)axis2) > center2)).findFirst().orElse(positions.get(0)));
    }

    private List<MutableQuad> getTransformedQuads(IBlockState state, IBakedModel model, EnumFacing side, Vec3d pos0, Vec3d pos1, Vec3d pos2, Vec3d pos3) {
        return model.func_188616_a(state, side, 0L).stream().map(quad -> {
            MutableQuad mutableQuad = new MutableQuad().fromBakedItem(quad);
            boolean positive = side.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
            Function<Vec3d, Vec3d> transformPosition = pos -> {
                switch (side.func_176740_k()) {
                    case X: {
                        return new Vec3d(positive ? 1.0 - pos.field_72449_c : pos.field_72449_c, pos.field_72448_b, pos.field_72450_a);
                    }
                    case Y: {
                        return new Vec3d(pos.field_72450_a, positive ? 1.0 - pos.field_72449_c : pos.field_72449_c, pos.field_72448_b);
                    }
                    case Z: {
                        return new Vec3d(pos.field_72448_b, pos.field_72450_a, positive ? 1.0 - pos.field_72449_c : pos.field_72449_c);
                    }
                }
                throw new IllegalArgumentException();
            };
            List<Vec3d> poses = Arrays.asList(transformPosition.apply(pos0), transformPosition.apply(pos1), transformPosition.apply(pos2), transformPosition.apply(pos3));
            List<MutableVertex> vertexes = Arrays.asList(mutableQuad.vertex_0, mutableQuad.vertex_1, mutableQuad.vertex_2, mutableQuad.vertex_3);
            List vertexesPoses = vertexes.stream().map(vertex -> new Vec3d((double)vertex.position_x, (double)vertex.position_y, (double)vertex.position_z)).collect(Collectors.toList());
            double minU = vertexes.stream().mapToDouble(vertex -> vertex.tex_u).min().orElse(0.0);
            double minV = vertexes.stream().mapToDouble(vertex -> vertex.tex_v).min().orElse(0.0);
            double maxU = vertexes.stream().mapToDouble(vertex -> vertex.tex_u).max().orElse(0.0);
            double maxV = vertexes.stream().mapToDouble(vertex -> vertex.tex_v).max().orElse(0.0);
            Stream.of(Pair.of((Object)false, (Object)false), Pair.of((Object)false, (Object)true), Pair.of((Object)true, (Object)true), Pair.of((Object)true, (Object)false)).forEach(minOrMaxPair -> {
                Vec3d newPos = (Vec3d)poses.get(this.getVertexIndex(poses, side.func_176740_k(), (Boolean)minOrMaxPair.getLeft(), (Boolean)minOrMaxPair.getRight()));
                MutableVertex vertex = (MutableVertex)vertexes.get(this.getVertexIndex(vertexesPoses, side.func_176740_k(), (Boolean)minOrMaxPair.getLeft(), (Boolean)minOrMaxPair.getRight()));
                vertex.positiond(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
                switch (side.func_176740_k()) {
                    case X: {
                        vertex.texf((float)(minU + (maxU - minU) * (positive ? 1.0 - newPos.field_72449_c : newPos.field_72449_c)), (float)(minV + (maxV - minV) * (1.0 - newPos.field_72448_b)));
                        break;
                    }
                    case Y: {
                        vertex.texf((float)(minU + (maxU - minU) * newPos.field_72450_a), (float)(minV + (maxV - minV) * (positive ? newPos.field_72449_c : 1.0 - newPos.field_72449_c)));
                        break;
                    }
                    case Z: {
                        vertex.texf((float)(minU + (maxU - minU) * (positive ? newPos.field_72450_a : 1.0 - newPos.field_72450_a)), (float)(minV + (maxV - minV) * (1.0 - newPos.field_72448_b)));
                    }
                }
            });
            return mutableQuad;
        }).collect(Collectors.toList());
    }

    private Vec3d rotate(Vec3d vec, Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return new Vec3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
            case CLOCKWISE_90: {
                return new Vec3d(1.0 - vec.field_72448_b, 1.0 - vec.field_72450_a, vec.field_72449_c);
            }
            case CLOCKWISE_180: {
                return new Vec3d(1.0 - vec.field_72450_a, 1.0 - vec.field_72448_b, vec.field_72449_c);
            }
            case COUNTERCLOCKWISE_90: {
                return new Vec3d(vec.field_72448_b, vec.field_72450_a, vec.field_72449_c);
            }
        }
        throw new IllegalArgumentException();
    }

    private void addRotatedQuads(List<MutableQuad> quads, IBlockState state, IBakedModel model, EnumFacing side, Rotation rotation, Vec3d pos0, Vec3d pos1, Vec3d pos2, Vec3d pos3) {
        quads.addAll(this.getTransformedQuads(state, model, side, this.rotate(pos0, rotation), this.rotate(pos1, rotation), this.rotate(pos2, rotation), this.rotate(pos3, rotation)));
    }

    public List<MutableQuad> bakeForKey(KeyPlugFacade key) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(key.state);
        BlockRenderLayer renderLayer = MinecraftForgeClient.getRenderLayer();
        ForgeHooksClient.setRenderLayer(null);
        ArrayList<MutableQuad> quads = new ArrayList<MutableQuad>();
        int pS = 2;
        int nS = 16 - pS;
        if (!key.isHollow) {
            quads.addAll(this.getTransformedQuads(key.state, model, key.side, new Vec3d(0.0, 1.0, 0.0), new Vec3d(1.0, 1.0, 0.0), new Vec3d(1.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 0.0)));
            quads.addAll(this.getTransformedQuads(key.state, model, key.side.func_176734_d(), new Vec3d((double)pS / 16.0, (double)nS / 16.0, (double)nS / 16.0), new Vec3d((double)nS / 16.0, (double)nS / 16.0, (double)nS / 16.0), new Vec3d((double)nS / 16.0, (double)pS / 16.0, (double)nS / 16.0), new Vec3d((double)pS / 16.0, (double)pS / 16.0, (double)nS / 16.0)));
        }
        for (Rotation rotation : Rotation.values()) {
            if (key.isHollow) {
                this.addRotatedQuads(quads, key.state, model, key.side, rotation, new Vec3d(0.0, rotation.ordinal() % 2 == 0 ? 0.25 : 0.0, 0.0), new Vec3d(0.25, rotation.ordinal() % 2 == 0 ? 0.25 : 0.0, 0.0), new Vec3d(0.25, rotation.ordinal() % 2 == 0 ? 1.0 : 0.75, 0.0), new Vec3d(0.0, rotation.ordinal() % 2 == 0 ? 1.0 : 0.75, 0.0));
            }
            this.addRotatedQuads(quads, key.state, model, key.side.func_176734_d(), rotation, new Vec3d(0.0, 1.0, 1.0), new Vec3d((double)pS / 16.0, (double)nS / 16.0, (double)nS / 16.0), new Vec3d((double)pS / 16.0, (double)pS / 16.0, (double)nS / 16.0), new Vec3d(0.0, 0.0, 1.0));
            if (!key.isHollow) continue;
            this.addRotatedQuads(quads, key.state, model, key.side.func_176734_d(), rotation, new Vec3d((double)pS / 16.0, rotation.ordinal() % 2 == 0 ? (double)nS / 16.0 : 0.75, (double)nS / 16.0), new Vec3d(0.25, rotation.ordinal() % 2 == 0 ? (double)nS / 16.0 : 0.75, (double)nS / 16.0), new Vec3d(0.25, rotation.ordinal() % 2 == 0 ? 0.25 : (double)pS / 16.0, (double)nS / 16.0), new Vec3d((double)pS / 16.0, rotation.ordinal() % 2 == 0 ? 0.25 : (double)pS / 16.0, (double)nS / 16.0));
        }
        if (key.isHollow) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                boolean positive;
                if (facing.func_176740_k() == key.side.func_176740_k()) continue;
                boolean bl = positive = key.side.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
                if (key.side.func_176740_k() == EnumFacing.Axis.Z && facing.func_176740_k() == EnumFacing.Axis.X || key.side.func_176740_k() == EnumFacing.Axis.X && facing.func_176740_k() == EnumFacing.Axis.Y || key.side.func_176740_k() == EnumFacing.Axis.Y && facing.func_176740_k() == EnumFacing.Axis.Z) {
                    quads.addAll(this.getTransformedQuads(key.state, model, facing, new Vec3d(positive ? 1.0 : (double)pS / 16.0, 0.25, 0.7501875), new Vec3d(positive ? 1.0 : (double)pS / 16.0, 0.75, 0.7501875), new Vec3d(positive ? (double)nS / 16.0 : 0.0, 0.75, 0.7501875), new Vec3d(positive ? (double)nS / 16.0 : 0.0, 0.25, 0.7501875)));
                    continue;
                }
                quads.addAll(this.getTransformedQuads(key.state, model, facing, new Vec3d(0.25, positive ? 1.0 : (double)pS / 16.0, 0.7501875), new Vec3d(0.25, positive ? (double)nS / 16.0 : 0.0, 0.7501875), new Vec3d(0.75, positive ? (double)nS / 16.0 : 0.0, 0.7501875), new Vec3d(0.75, positive ? 1.0 : (double)pS / 16.0, 0.7501875)));
            }
        }
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)renderLayer);
        for (MutableQuad quad : quads) {
            int tint = quad.getTint();
            if (tint == -1) continue;
            quad.setTint(tint * EnumFacing.field_82609_l.length + key.side.ordinal());
        }
        return quads;
    }

    public List<BakedQuad> bake(KeyPlugFacade key) {
        List<MutableQuad> mutableQuads = this.bakeForKey(key);
        ArrayList<BakedQuad> baked = new ArrayList<BakedQuad>();
        for (MutableQuad quad : mutableQuads) {
            baked.add(quad.toBakedItem());
        }
        if (BCModules.TRANSPORT.isLoaded() && key.state.func_185913_b() && !key.isHollow) {
            baked.addAll(BCTransportModels.BAKER_PLUG_BLOCKER.bake((PluggableModelKey)new KeyPlugBlocker(key.side)));
        }
        return baked;
    }
}

