/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.chargers.handler;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import se.gory_moon.chargers.Configs;
import se.gory_moon.chargers.compat.Baubles;
import se.gory_moon.chargers.tile.TileEntityWirelessCharger;

@Mod.EventBusSubscriber(modid="chargers")
public class WirelessHandler {
    public static WirelessHandler INSTANCE = new WirelessHandler();
    private Int2ObjectMap<ObjectSet<BlockPos>> dimensionChargers = new Int2ObjectOpenHashMap();

    public void register(TileEntityWirelessCharger charger) {
        ObjectSet<BlockPos> chargers = this.getDimensionChargers(charger.func_145831_w());
        chargers.add((Object)charger.func_174877_v().func_185334_h());
    }

    public void unRegister(TileEntityWirelessCharger charger) {
        ObjectSet<BlockPos> chargers = this.getDimensionChargers(charger.func_145831_w());
        chargers.remove((Object)charger.func_174877_v().func_185334_h());
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT || event.phase != TickEvent.Phase.START || event.player.func_175149_v()) {
            return;
        }
        INSTANCE.chargeItems(event.player);
    }

    public void chargeItems(EntityPlayer player) {
        ObjectSet<BlockPos> chargers = this.getDimensionChargers(player.field_70170_p);
        if (chargers.isEmpty()) {
            return;
        }
        BlockPos playerPos = player.func_180425_c();
        ObjectIterator iterator = chargers.iterator();
        while (iterator.hasNext()) {
            BlockPos pos = (BlockPos)iterator.next();
            TileEntityWirelessCharger charger = this.getCharger((IBlockAccess)player.field_70170_p, pos);
            if (charger != null) {
                if (!charger.canCharge() || !this.inRange(charger.func_174877_v(), playerPos) || !this.chargeItems(player, charger)) continue;
                return;
            }
            iterator.remove();
        }
    }

    private TileEntityWirelessCharger getCharger(IBlockAccess world, BlockPos pos) {
        TileEntity te;
        if (((World)world).func_175667_e(pos) && (te = world.func_175625_s(pos)) instanceof TileEntityWirelessCharger) {
            return (TileEntityWirelessCharger)te;
        }
        return null;
    }

    private boolean chargeItems(EntityPlayer player, TileEntityWirelessCharger charger) {
        charger.updateAvailable();
        boolean result = charger.chargeItems((NonNullList<ItemStack>)player.field_71071_by.field_70460_b);
        result |= charger.chargeItems((NonNullList<ItemStack>)player.field_71071_by.field_70462_a);
        result |= charger.chargeItems((NonNullList<ItemStack>)player.field_71071_by.field_184439_c);
        if (result |= Baubles.INSTANCE.chargeItems(player, charger)) {
            player.field_71069_bz.func_75142_b();
        }
        return result;
    }

    private boolean inRange(BlockPos a, BlockPos b) {
        int range = Configs.chargers.wireless.wirelessRange;
        int dx = a.func_177958_n() - b.func_177958_n();
        if (dx > range || dx < -range) {
            return false;
        }
        int dz = a.func_177952_p() - b.func_177952_p();
        if (dz > range || dz < -range) {
            return false;
        }
        int dy = a.func_177956_o() - b.func_177956_o();
        return dx * dx + dy * dy + dz * dz <= range * range;
    }

    private ObjectSet<BlockPos> getDimensionChargers(World world) {
        return (ObjectSet)this.dimensionChargers.computeIfAbsent((Object)world.field_73011_w.getDimension(), integer -> new ObjectOpenHashSet());
    }
}

