/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.util;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.stream.StreamSupport;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Items;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    public static TextureAtlasSprite getTopTextureFromBlock(Block block, int meta) {
        IBlockState state = block.func_176203_a(meta);
        return RenderUtils.getTopTextureFromBlockstate(state);
    }

    public static TextureAtlasSprite getTopTextureFromBlockstate(IBlockState state) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        if (model != Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a()) {
            List quads = model.func_188616_a(state, EnumFacing.UP, 0L);
            return quads.size() >= 1 ? ((BakedQuad)quads.get(0)).func_187508_a() : Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
        }
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
    }

    public static TextureAtlasSprite getTextureFromBlock(Block block, int meta) {
        IBlockState state = block.func_176203_a(meta);
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
    }

    public static TextureAtlasSprite getTextureFromBlockstate(IBlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getTransforms(IBakedModel model) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            TRSRTransformation transformation = new TRSRTransformation((Matrix4f)model.handlePerspective(type).getRight());
            if (transformation.equals((Object)TRSRTransformation.identity())) continue;
            builder.put((Object)type, (Object)TRSRTransformation.blockCenterToCorner((TRSRTransformation)transformation));
        }
        return builder.build();
    }

    public static void renderInvalidArea(World world, BlockPos blockPos, int yOffset) {
        if (StreamSupport.stream(Minecraft.func_71410_x().field_71439_g.func_184214_aD().spliterator(), false).anyMatch(stack -> !stack.func_190926_b() && stack.func_77973_b() == Items.field_151058_ca)) {
            RenderUtils.renderUsedArea(world, blockPos, yOffset, 0.55f, 0.15f);
        }
    }

    public static void renderUsedArea(World world, BlockPos blockPos, int yOffset, float invalidAplha, float validAplha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2848);
        GlStateManager.func_179126_j();
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179136_a((float)-0.1f, (float)-10.0f);
        GlStateManager.func_179088_q();
        for (int xo = -3; xo <= 3; ++xo) {
            for (int yo = yOffset; yo <= 1 + yOffset; ++yo) {
                for (int zo = -3; zo <= 3; ++zo) {
                    BlockPos pos = blockPos.func_177982_a(xo, yo, zo);
                    if (xo <= 1 && xo >= -1 && zo <= 1 && zo >= -1 || pos.func_177956_o() < 0) continue;
                    IBlockState state = world.func_180495_p(pos);
                    if (!state.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                        GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)invalidAplha);
                        RenderUtils.drawBoundingBoxOutline(new AxisAlignedBB(pos).func_72317_d(-Minecraft.func_71410_x().func_175598_ae().field_78730_l, -Minecraft.func_71410_x().func_175598_ae().field_78731_m, -Minecraft.func_71410_x().func_175598_ae().field_78728_n));
                        RenderUtils.drawBoundingBox(state.func_185900_c((IBlockAccess)world, pos).func_186670_a(pos).func_72317_d(-Minecraft.func_71410_x().func_175598_ae().field_78730_l, -Minecraft.func_71410_x().func_175598_ae().field_78731_m, -Minecraft.func_71410_x().func_175598_ae().field_78728_n));
                        continue;
                    }
                    GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)validAplha);
                    RenderUtils.drawBoundingBoxOutline(new AxisAlignedBB(pos).func_72317_d(-Minecraft.func_71410_x().func_175598_ae().field_78730_l, -Minecraft.func_71410_x().func_175598_ae().field_78731_m, -Minecraft.func_71410_x().func_175598_ae().field_78728_n));
                }
            }
        }
        GlStateManager.func_179113_r();
        GL11.glDisable((int)2848);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBoundingBox(AxisAlignedBB axisalignedbb) {
        GL11.glBegin((int)7);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72340_a, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72339_c);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72337_e, (double)axisalignedbb.field_72334_f);
        GL11.glVertex3d((double)axisalignedbb.field_72336_d, (double)axisalignedbb.field_72338_b, (double)axisalignedbb.field_72334_f);
        GL11.glEnd();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBoundingBoxOutline(AxisAlignedBB par1AxisAlignedBB) {
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glEnd();
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72339_c);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72336_d, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72338_b, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glVertex3d((double)par1AxisAlignedBB.field_72340_a, (double)par1AxisAlignedBB.field_72337_e, (double)par1AxisAlignedBB.field_72334_f);
        GL11.glEnd();
    }
}

