/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tweaker.recipes;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import se.gory_moon.horsepower.HorsePowerMod;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.recipes.PressRecipe;
import se.gory_moon.horsepower.tweaker.BaseHPAction;
import se.gory_moon.horsepower.tweaker.TweakerPluginImpl;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.horsepower.Press")
public class PressRecipeTweaker {
    @ZenMethod
    public static void add(IIngredient input, IItemStack output) {
        AddPressRecipe recipe = new AddPressRecipe(input, output);
        TweakerPluginImpl.toAdd.add(recipe);
        TweakerPluginImpl.actions.add(recipe);
    }

    @ZenMethod
    public static void add(IIngredient input, ILiquidStack output) {
        AddPressRecipe recipe = new AddPressRecipe(input, output);
        TweakerPluginImpl.toAdd.add(recipe);
        TweakerPluginImpl.actions.add(recipe);
    }

    @ZenMethod
    public static void remove(IIngredient output) {
        RemovePressRecipe recipe = new RemovePressRecipe(output);
        TweakerPluginImpl.toRemove.add(recipe);
        TweakerPluginImpl.actions.add(recipe);
    }

    private static class RemovePressRecipe
    extends BaseHPAction {
        private final IIngredient output;

        public RemovePressRecipe(IIngredient output) {
            this.output = output;
        }

        public void apply() {
            ArrayList<PressRecipe> toRemove = new ArrayList<PressRecipe>();
            Collection<PressRecipe> recipeList = HPRecipes.instance().getPressRecipes();
            for (PressRecipe recipe : recipeList) {
                if (!OreDictionary.itemMatches((ItemStack)CraftTweakerMC.getItemStack((IIngredient)this.output), (ItemStack)recipe.getOutput(), (boolean)false)) continue;
                toRemove.add(recipe);
            }
            for (int i = toRemove.size() - 1; i >= 0; --i) {
                recipeList.remove(toRemove.get(i));
            }
        }

        public String describe() {
            return "Removing press recipes for " + this.output;
        }
    }

    private static class AddPressRecipe
    extends BaseHPAction {
        private final IIngredient input;
        private final IItemStack output;
        private final ILiquidStack fluidOuput;

        public AddPressRecipe(IIngredient input, IItemStack output) {
            this.input = input;
            this.output = output;
            this.fluidOuput = null;
        }

        public AddPressRecipe(IIngredient input, ILiquidStack output) {
            this.input = input;
            this.fluidOuput = output;
            this.output = null;
        }

        public void apply() {
            List items = this.input.getItems();
            if (items == null) {
                HorsePowerMod.logger.error("Cannot turn " + this.input.toString() + " into a press recipe");
            }
            ItemStack[] items2 = CraftTweakerMC.getItemStacks((List)items);
            ItemStack output2 = CraftTweakerMC.getItemStack((IItemStack)this.output);
            FluidStack fluidStack = CraftTweakerMC.getLiquidStack((ILiquidStack)this.fluidOuput);
            for (ItemStack stack : items2) {
                PressRecipe recipe = fluidStack == null ? new PressRecipe(stack, output2, ItemStack.field_190927_a, 0, 0) : new PressRecipe(stack, fluidStack);
                HPRecipes.instance().addPressRecipe(recipe);
            }
        }

        public String describe() {
            return "Adding press recipe for " + this.input;
        }
    }
}

