/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.tileentity;

import com.google.common.collect.Lists;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockChopper;
import se.gory_moon.horsepower.recipes.HPRecipeBase;
import se.gory_moon.horsepower.recipes.HPRecipes;
import se.gory_moon.horsepower.tileentity.TileEntityHPHorseBase;
import se.gory_moon.horsepower.util.Localization;

public class TileEntityChopper
extends TileEntityHPHorseBase {
    private int currentWindup;
    private int currentItemChopTime;
    private int totalItemChopTime;
    private float visualWindup = 0.0f;
    private float oldVisualWindup = -1.0f;

    public TileEntityChopper() {
        super(2);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("currentWindup", this.currentWindup);
        compound.func_74768_a("chopTime", this.currentItemChopTime);
        compound.func_74768_a("totalChopTime", this.totalItemChopTime);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.currentWindup = compound.func_74762_e("currentWindup");
        if (this.getStackInSlot(0).func_190916_E() > 0) {
            this.currentItemChopTime = compound.func_74762_e("chopTime");
            this.totalItemChopTime = compound.func_74762_e("totalChopTime");
        } else {
            this.currentItemChopTime = 0;
            this.totalItemChopTime = 1;
        }
    }

    @Override
    public IExtendedBlockState getExtendedState(IExtendedBlockState state) {
        state = (IExtendedBlockState)state.func_177226_a((IProperty)BlockChopper.FACING, (Comparable)this.getForward());
        state = (IExtendedBlockState)state.func_177226_a(BlockChopper.PART, state.func_177229_b(BlockChopper.PART));
        return state;
    }

    public void setTextureBlock(NBTTagCompound textureBlock) {
        this.getTileData().func_74782_a("textureBlock", (NBTBase)textureBlock);
    }

    public NBTTagCompound getTextureBlock() {
        return this.getTileData().func_74775_l("textureBlock");
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return index != 1 && index == 0 && HPRecipes.instance().hasChopperRecipe(stack, false) && this.getStackInSlot(1).func_190926_b() && this.getStackInSlot(0).func_190926_b();
    }

    @Override
    public boolean validateArea() {
        if (this.searchPos == null) {
            this.searchPos = Lists.newArrayList();
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    if (x <= 1 && x >= -1 && z <= 1 && z >= -1) continue;
                    this.searchPos.add(this.func_174877_v().func_177982_a(x, 0, z));
                    this.searchPos.add(this.func_174877_v().func_177982_a(x, 1, z));
                }
            }
        }
        for (BlockPos pos : this.searchPos) {
            if (this.func_145831_w().func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, pos)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        float windup = Configs.general.pointsForWindup > 0 ? (float)Configs.general.pointsForWindup : 1.0f;
        this.visualWindup = -0.74f + 0.74f * ((float)this.currentWindup / (windup - 1.0f));
    }

    @Override
    public boolean targetReached() {
        ++this.currentWindup;
        if (this.currentWindup >= Configs.general.pointsForWindup) {
            this.currentWindup = 0;
            ++this.currentItemChopTime;
            if (this.currentItemChopTime >= this.totalItemChopTime) {
                this.currentItemChopTime = 0;
                this.totalItemChopTime = HPRecipes.instance().getChoppingTime(this.getStackInSlot(0), false);
                this.chopItem();
                return true;
            }
        }
        this.func_70296_d();
        return false;
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        boolean flag;
        ItemStack itemstack = this.getStackInSlot(index);
        super.setInventorySlotContents(index, stack);
        if (index == 1 && this.getStackInSlot(1).func_190926_b()) {
            this.func_70296_d();
        }
        boolean bl = flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        if (index == 0 && !flag) {
            this.totalItemChopTime = HPRecipes.instance().getChoppingTime(stack, false);
            this.currentItemChopTime = 0;
            this.currentWindup = 0;
            this.func_70296_d();
        }
    }

    private void chopItem() {
        if (this.canWork()) {
            ItemStack input = this.getStackInSlot(0);
            ItemStack result = this.getRecipeItemStack();
            ItemStack output = this.getStackInSlot(1);
            if (output.func_190926_b()) {
                this.setInventorySlotContents(1, result.func_77946_l());
            } else if (output.func_77973_b() == result.func_77973_b()) {
                output.func_190917_f(result.func_190916_E());
            }
            input.func_190918_g(1);
            this.func_70296_d();
        }
    }

    @Override
    public ItemStack getRecipeItemStack() {
        return HPRecipes.instance().getChopperResult(this.getStackInSlot(0), false);
    }

    @Override
    public HPRecipeBase getRecipe() {
        return HPRecipes.instance().getChoppingBlockRecipe(this.getStackInSlot(0), false);
    }

    @Override
    public int getPositionOffset() {
        return 0;
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.totalItemChopTime;
            }
            case 1: {
                return this.currentItemChopTime;
            }
            case 2: {
                return this.currentWindup;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.totalItemChopTime = value;
                break;
            }
            case 1: {
                this.currentItemChopTime = value;
            }
            case 2: {
                this.currentWindup = value;
            }
        }
    }

    @Override
    public int getFieldCount() {
        return 3;
    }

    @Override
    public String getName() {
        return "container.chopper";
    }

    @Override
    public int getOutputSlot() {
        return 1;
    }

    public float getVisualWindup() {
        return this.visualWindup;
    }

    public float getOldVisualWindup() {
        return this.oldVisualWindup;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        if (this.valid) {
            return super.func_145748_c_();
        }
        return new TextComponentTranslation(Localization.INFO.CHOPPING_INVALID.key(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED));
    }
}

