/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.math.Vec3d;

public class VectorBuilder {
    private Random random = new Random();
    private Vec3d vec;
    private List<Function<Vec3d, Vec3d>> operations = Lists.newArrayList();

    public VectorBuilder addOperation(Function<Vec3d, Vec3d> operation) {
        this.operations.add(operation);
        return this;
    }

    public VectorBuilder offset(double offset) {
        return this.offset(offset, offset, offset);
    }

    public VectorBuilder offset(double x, double y, double z) {
        return this.addOperation(vec -> {
            Preconditions.checkNotNull((Object)vec, (Object)"vec");
            return vec.func_72441_c(x, y, z);
        });
    }

    public VectorBuilder rand(double multiplier) {
        return this.rand(multiplier, multiplier, multiplier);
    }

    public VectorBuilder rand(double multiplierX, double multiplierY, double multiplierZ) {
        return this.addOperation(vec -> {
            Preconditions.checkNotNull((Object)vec, (Object)"vec");
            return vec.func_72441_c(this.random.nextDouble() * multiplierX, this.random.nextDouble() * multiplierY, this.random.nextDouble() * multiplierZ);
        });
    }

    public VectorBuilder setGaussian(double multiplierX, double multiplierY, double multiplierZ) {
        return this.addOperation(vec -> {
            Preconditions.checkNotNull((Object)vec, (Object)"vec");
            return vec.func_72441_c(this.random.nextGaussian() * multiplierX, this.random.nextGaussian() * multiplierY, this.random.nextGaussian() * multiplierZ);
        });
    }

    public VectorBuilder setGaussian(double multiplier) {
        return this.setGaussian(multiplier, multiplier, multiplier);
    }

    public Vec3d build(Vec3d initial) {
        this.vec = initial;
        this.operations.forEach(c -> {
            this.vec = (Vec3d)c.apply(this.vec);
        });
        return this.vec;
    }
}

