/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.oredict.OreIngredient;

public class StackIngredient
extends Ingredient {
    private final Map<Ingredient, Integer> internal;
    private ItemStack[] cachedStacks;

    protected StackIngredient(Map<Ingredient, Integer> ingredients) {
        super(0);
        this.internal = ingredients;
    }

    protected StackIngredient(Ingredient ingredient, int amount) {
        super(0);
        this.internal = new HashMap<Ingredient, Integer>();
        this.internal.put(ingredient, amount);
    }

    public static StackIngredient fromIngredient(int count, Ingredient ingredient) {
        return new StackIngredient(ingredient, count);
    }

    public static StackIngredient fromStacks(ItemStack ... stacks) {
        return new StackIngredient(Arrays.stream(stacks).collect(Collectors.toMap(xva$0 -> Ingredient.func_193369_a((ItemStack[])new ItemStack[]{xva$0}), ItemStack::func_190916_E)));
    }

    public static StackIngredient fromStacks(Collection<ItemStack> stacks) {
        return new StackIngredient(stacks.stream().collect(Collectors.toMap(xva$0 -> Ingredient.func_193369_a((ItemStack[])new ItemStack[]{xva$0}), ItemStack::func_190916_E)));
    }

    public static StackIngredient fromOre(int count, String ore) {
        return StackIngredient.fromIngredient(count, (Ingredient)new OreIngredient(ore));
    }

    public static StackIngredient fromOre(String ore) {
        return StackIngredient.fromOre(1, ore);
    }

    public static StackIngredient mergeStacked(List<StackIngredient> ingredients) {
        HashMap<Ingredient, Integer> map = new HashMap<Ingredient, Integer>();
        ingredients.forEach(stackIngredient -> map.putAll(stackIngredient.internal));
        return new StackIngredient(map);
    }

    public static StackIngredient merge(Map<Ingredient, Integer> ingredients) {
        return new StackIngredient(ingredients);
    }

    public boolean apply(@Nullable ItemStack stack) {
        return stack != null && this.internal.entrySet().stream().anyMatch(entry -> stack.func_190916_E() >= (Integer)entry.getValue() && ((Ingredient)entry.getKey()).apply(stack));
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        if (this.cachedStacks == null) {
            ArrayList stacks = new ArrayList();
            for (Map.Entry<Ingredient, Integer> entry : this.internal.entrySet()) {
                Arrays.stream(entry.getKey().func_193365_a()).map(stack -> this.withCount((ItemStack)stack, (Integer)entry.getValue())).forEach(stacks::add);
            }
            this.cachedStacks = stacks.toArray(new ItemStack[stacks.size()]);
        }
        return this.cachedStacks;
    }

    private ItemStack withCount(ItemStack stack, int count) {
        ItemStack newStack = stack.func_77946_l();
        newStack.func_190920_e(count);
        return newStack;
    }

    protected void invalidate() {
        super.invalidate();
        this.cachedStacks = null;
    }

    public int getCount(ItemStack stack) {
        return (Integer)this.internal.entrySet().stream().filter(entry -> ((Ingredient)entry.getKey()).apply(stack)).findFirst().get().getValue();
    }
}

