/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.testing;

import betterwithmods.common.registry.bulk.manager.CookingPotManager;
import betterwithmods.common.registry.bulk.recipes.CookingPotRecipe;
import betterwithmods.testing.base.BaseTest;
import betterwithmods.testing.base.Before;
import betterwithmods.testing.base.Test;
import betterwithmods.util.StackIngredient;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import org.fest.assertions.Assertions;

public class CookingPotTests
extends BaseTest {
    private CookingPotManager TEST_MANAGER;
    private List<Ingredient> inputs = Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks(new ItemStack(Blocks.field_150347_e))});
    private List<ItemStack> outputs = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Items.field_151045_i)});
    private CookingPotRecipe recipe = new CookingPotRecipe(this.inputs, this.outputs, 1);

    @Before
    public void beforeTest() {
        this.TEST_MANAGER = new CookingPotManager();
    }

    @Test
    public void testRecipeAddition() {
        Assertions.assertThat(this.TEST_MANAGER.getRecipes()).isEmpty();
        this.TEST_MANAGER.addRecipe(this.recipe);
        Assertions.assertThat(this.TEST_MANAGER.getRecipes()).hasSize(1);
    }

    @Test
    public void testRecipeRemoval() {
        Assertions.assertThat((boolean)this.recipe.isInvalid()).isFalse();
        Assertions.assertThat(this.TEST_MANAGER.getRecipes()).isEmpty();
        this.TEST_MANAGER.addRecipe(this.recipe);
        Assertions.assertThat(this.TEST_MANAGER.getRecipes()).isNotEmpty();
        this.TEST_MANAGER.remove(this.recipe);
    }
}

